import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
/**
 * Generic component used for reacting to a click event happening outside of a
 * given `children` element.
 */

var ClickListener = /*#__PURE__*/function (_React$Component) {
  _inherits(ClickListener, _React$Component);

  var _super = _createSuper(ClickListener);

  function ClickListener(props) {
    var _this;

    _classCallCheck(this, ClickListener);

    _this = _super.call(this, props); // We manually bind handlers in this Component, versus using class
    // properties, so that we can properly test the `handleRef` handler with
    // enzyme.

    _this.handleRef = _this.handleRef.bind(_assertThisInitialized(_this));
    _this.handleDocumentClick = _this.handleDocumentClick.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(ClickListener, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.addEventListener('click', this.handleDocumentClick);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.removeEventListener('click', this.handleDocumentClick);
    }
  }, {
    key: "handleDocumentClick",
    value: function handleDocumentClick(evt) {
      if (this.element) {
        if (this.element.contains && !this.element.contains(ClickListener.getEventTarget(evt))) {
          this.props.onClickOutside(evt);
        }
      }
    }
  }, {
    key: "handleRef",
    value: function handleRef(el) {
      var children = this.props.children;
      this.element = el;
      /**
       * One important note, `children.ref` corresponds to a `ref` prop passed in
       * directly to the child, not necessarily a `ref` defined in the component.
       * This means that here we target the following `ref` location:
       *
       * <ClickListener onClickOutside={() => {}}>
       *   <Child ref={targetedRefHere} />
       * </ClickListener>
       */

      if (children.ref && typeof children.ref === 'function') {
        children.ref(el);
      }
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.cloneElement(this.props.children, {
        ref: this.handleRef
      });
    }
  }], [{
    key: "getEventTarget",
    value: function getEventTarget(evt) {
      // support Shadow DOM
      if (evt.composed && typeof evt.composedPath === 'function') {
        return evt.composedPath()[0];
      }

      return evt.target;
    }
  }]);

  return ClickListener;
}(React.Component);

_defineProperty(ClickListener, "propTypes", {
  children: PropTypes.element.isRequired,
  onClickOutside: PropTypes.func.isRequired
});

export { ClickListener as default };