import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { useFeatureFlag } from '../components/FeatureFlags';
export function createComponentToggle(spec) {
  var name = spec.name,
      _spec$flag = spec.flag,
      flag = _spec$flag === void 0 ? 'enable-v11-release' : _spec$flag,
      next = spec.next,
      classic = spec.classic;

  function ComponentToggle(props, ref) {
    var enabled = useFeatureFlag(flag);

    if (enabled) {
      if (next) {
        return /*#__PURE__*/React.createElement(next, _objectSpread(_objectSpread({}, props), {}, {
          ref: ref
        }));
      }

      return null;
    }

    return /*#__PURE__*/React.createElement(classic, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref
    }));
  }

  var wrappedComponent = /*#__PURE__*/React.forwardRef(ComponentToggle);
  wrappedComponent.displayName = "FeatureToggle(".concat(name, ")");
  return wrappedComponent;
}