/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { warning } from '../internal/warning';
var didWarnAboutDeprecation = {};

function deprecateFieldOnObject(object, field, Component, message) {
  Object.defineProperty(object, field, {
    enumerable: true,
    get: function get() {
      if (!didWarnAboutDeprecation[field]) {
        process.env.NODE_ENV !== "production" ? warning(false, message || "The ".concat(field, " field has been deprecated on the ").concat(object.displayName, " object. ") + "Please import and use ".concat(Component.displayName || Component.name || 'the field', " directly.")) : void 0;
        didWarnAboutDeprecation[field] = true;
      }

      return Component;
    }
  });
}

export { deprecateFieldOnObject };