"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _Text = require("../Text");

var _keyboard = require("../../internal/keyboard");

var _useId = require("../../internal/useId");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _excluded = ["children", "className", "iconDescription", "open", "onHeadingClick", "renderExpando", "title", "disabled"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;

var defaultRenderExpando = function defaultRenderExpando(props) {
  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    type: "button"
  }, props));
};

function AccordionItem(_ref) {
  var _cx;

  var children = _ref.children,
      customClassName = _ref.className,
      iconDescription = _ref.iconDescription,
      _ref$open = _ref.open,
      open = _ref$open === void 0 ? false : _ref$open,
      onHeadingClick = _ref.onHeadingClick,
      _ref$renderExpando = _ref.renderExpando,
      Expando = _ref$renderExpando === void 0 ? defaultRenderExpando : _ref$renderExpando,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'title' : _ref$title,
      disabled = _ref.disabled,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useState = (0, _react.useState)(open),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var _useState3 = (0, _react.useState)(open),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      prevIsOpen = _useState4[0],
      setPrevIsOpen = _useState4[1];

  var _useState5 = (0, _react.useState)(''),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      animation = _useState6[0],
      setAnimation = _useState6[1];

  var id = (0, _useId.useId)('accordion-item');
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--accordion__item"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--accordion__item--active"), isOpen), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--accordion__item--").concat(animation), animation), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--accordion__item--disabled"), disabled), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));

  if (open !== prevIsOpen) {
    setAnimation(isOpen ? 'collapsing' : 'expanding');
    setIsOpen(open);
    setPrevIsOpen(open);
  } // When the AccordionItem heading is clicked, toggle the open state of the
  // panel


  function onClick(event) {
    var nextValue = !isOpen;
    setAnimation(isOpen ? 'collapsing' : 'expanding');
    setIsOpen(nextValue);

    if (onHeadingClick) {
      // TODO: normalize signature, potentially:
      // onHeadingClick :: (event: Event, state: { isOpen: Boolean }) => any
      onHeadingClick({
        isOpen: nextValue,
        event: event
      });
    }
  } // If the AccordionItem is open, and the user hits the ESC key, then close it


  function onKeyDown(event) {
    if (isOpen && (0, _keyboard.match)(event, _keyboard.keys.Escape)) {
      setIsOpen(false);
    }
  }

  function handleAnimationEnd(event) {
    if (rest.handleAnimationEnd) {
      rest.handleAnimationEnd(event);
    }

    setAnimation('');
  }

  return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
    className: className
  }, rest, {
    onAnimationEnd: handleAnimationEnd
  }), /*#__PURE__*/_react.default.createElement(Expando, {
    disabled: disabled,
    "aria-controls": id,
    "aria-expanded": isOpen,
    className: "".concat(prefix, "--accordion__heading"),
    onClick: onClick,
    onKeyDown: onKeyDown,
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/_react.default.createElement(_Text.Text, {
    as: "div",
    className: "".concat(prefix, "--accordion__title")
  }, title)), /*#__PURE__*/_react.default.createElement("div", {
    id: id,
    className: "".concat(prefix, "--accordion__content")
  }, children));
}

AccordionItem.propTypes = {
  /**
   * Provide the contents of your AccordionItem
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether an individual AccordionItem should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * The description of the expando icon.
   */
  iconDescription: (0, _deprecate.default)(_propTypes.default.string, 'The `iconDescription` prop has been deprecated as it is no longer ' + 'required. Feel free to remove this prop from <AccordionItem>. This ' + 'prop will be removed in the next major release of ' + '`carbon-components-react`'),

  /**
   * The handler of the massaged `click` event.
   */
  onClick: _propTypes.default.func,

  /**
   * The handler of the massaged `click` event on the heading.
   */
  onHeadingClick: _propTypes.default.func,

  /**
   * `true` to open the expando.
   */
  open: _propTypes.default.bool,

  /**
   * The callback function to render the expando button.
   * Can be a React component class.
   */
  renderExpando: _propTypes.default.func,

  /**
   * The accordion title.
   */
  title: _propTypes.default.node
};
var _default = AccordionItem;
exports.default = _default;