"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.playground = exports.aspectRatio = exports.default = void 0;

require("./AspectRatio-story.scss");

var _addonKnobs = require("@storybook/addon-knobs");

var _react = _interopRequireDefault(require("react"));

var _Grid = require("../Grid");

var _ = require("./");

var _AspectRatio = _interopRequireDefault(require("./AspectRatio.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/AspectRatio',
  component: _.AspectRatio,
  decorators: [_addonKnobs.withKnobs, function (story) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "aspect-ratio-story"
    }, story());
  }],
  parameters: {
    docs: {
      page: _AspectRatio.default
    }
  }
};
exports.default = _default;

var aspectRatio = function aspectRatio() {
  return /*#__PURE__*/_react.default.createElement(_Grid.Grid, null, /*#__PURE__*/_react.default.createElement(_Grid.Row, null, /*#__PURE__*/_react.default.createElement(_Grid.Column, null, /*#__PURE__*/_react.default.createElement(_.AspectRatio, {
    ratio: "1x1"
  }, "Content")), /*#__PURE__*/_react.default.createElement(_Grid.Column, null, /*#__PURE__*/_react.default.createElement(_.AspectRatio, {
    ratio: "1x1"
  }, "Content")), /*#__PURE__*/_react.default.createElement(_Grid.Column, null, /*#__PURE__*/_react.default.createElement(_.AspectRatio, {
    ratio: "1x1"
  }, "Content")), /*#__PURE__*/_react.default.createElement(_Grid.Column, null, /*#__PURE__*/_react.default.createElement(_.AspectRatio, {
    ratio: "1x1"
  }, "Content"))));
};

exports.aspectRatio = aspectRatio;

var playground = function playground() {
  var ratio = (0, _addonKnobs.select)('ratio', ['16x9', '9x16', '2x1', '1x2', '4x3', '3x4', '1x1'], '1x1');
  return /*#__PURE__*/_react.default.createElement(_Grid.Grid, null, /*#__PURE__*/_react.default.createElement(_Grid.Row, null, /*#__PURE__*/_react.default.createElement(_Grid.Column, null, /*#__PURE__*/_react.default.createElement(_.AspectRatio, {
    ratio: ratio
  }, "Content")), /*#__PURE__*/_react.default.createElement(_Grid.Column, null, /*#__PURE__*/_react.default.createElement(_.AspectRatio, {
    ratio: ratio
  }, "Content")), /*#__PURE__*/_react.default.createElement(_Grid.Column, null, /*#__PURE__*/_react.default.createElement(_.AspectRatio, {
    ratio: ratio
  }, "Content")), /*#__PURE__*/_react.default.createElement(_Grid.Column, null, /*#__PURE__*/_react.default.createElement(_.AspectRatio, {
    ratio: ratio
  }, "Content"))));
};

exports.playground = playground;