"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.playground = exports.skeleton = exports.breadcrumbWithOverflowMenu = exports.breadcrumb = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Breadcrumb = require("../Breadcrumb");

var _OverflowMenu = _interopRequireDefault(require("../OverflowMenu"));

var _OverflowMenuItem = _interopRequireDefault(require("../OverflowMenuItem"));

var _Breadcrumb2 = _interopRequireDefault(require("./Breadcrumb.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
var _default = {
  title: 'Components/Breadcrumb',
  component: _Breadcrumb.Breadcrumb,
  subcomponents: {
    BreadcrumbItem: _Breadcrumb.BreadcrumbItem,
    BreadcrumbSkeleton: _Breadcrumb.BreadcrumbSkeleton
  },
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _Breadcrumb2.default
    }
  }
};
exports.default = _default;

var breadcrumb = function breadcrumb() {
  return /*#__PURE__*/_react.default.createElement(_Breadcrumb.Breadcrumb, null, /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, /*#__PURE__*/_react.default.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 3"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, "Breadcrumb 4"));
};

exports.breadcrumb = breadcrumb;

var breadcrumbWithOverflowMenu = function breadcrumbWithOverflowMenu() {
  return /*#__PURE__*/_react.default.createElement(_Breadcrumb.Breadcrumb, null, /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, /*#__PURE__*/_react.default.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    "data-floating-menu-container": true
  }, /*#__PURE__*/_react.default.createElement(_OverflowMenu.default, null, /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Breadcrumb 3"
  }), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Breadcrumb 4"
  }))), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 5"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, "Breadcrumb 6"));
};

exports.breadcrumbWithOverflowMenu = breadcrumbWithOverflowMenu;

var skeleton = function skeleton() {
  return /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbSkeleton, null);
};

exports.skeleton = skeleton;

var props = function props() {
  return {
    className: 'some-class',
    noTrailingSlash: (0, _addonKnobs.boolean)('No trailing slash (noTrailingSlash)', false),
    onClick: (0, _addonActions.action)('onClick')
  };
};

var playground = function playground() {
  return /*#__PURE__*/_react.default.createElement(_Breadcrumb.Breadcrumb, props(), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, /*#__PURE__*/_react.default.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, (0, _extends2.default)({
    href: "#"
  }, props(), {
    isCurrentPage: (0, _addonKnobs.boolean)('Is current page (isCurrentPage)', false)
  }), "Breadcrumb 3"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, "Breadcrumb 4"));
};

exports.playground = playground;