"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _types = require("../../prop-types/types");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _events = require("../../tools/events");

var _keyboard = require("../../internal/keyboard");

var _usePrefix = require("../../internal/usePrefix");

var _useId = require("../../internal/useId");

var _toggleClass = _interopRequireDefault(require("../../tools/toggleClass"));

var _FeatureFlags = require("../FeatureFlags");

var _excluded = ["children", "as", "className", "disabled", "small", "size", "kind", "href", "isExpressive", "isSelected", "tabIndex", "type", "renderIcon", "dangerDescription", "iconDescription", "hasIconOnly", "tooltipPosition", "tooltipAlignment", "onClick", "onBlur", "onFocus", "onMouseEnter", "onMouseLeave"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var Button = /*#__PURE__*/_react.default.forwardRef(function Button(_ref, ref) {
  var _classNames;

  var children = _ref.children,
      as = _ref.as,
      className = _ref.className,
      disabled = _ref.disabled,
      small = _ref.small,
      size = _ref.size,
      kind = _ref.kind,
      href = _ref.href,
      isExpressive = _ref.isExpressive,
      isSelected = _ref.isSelected,
      tabIndex = _ref.tabIndex,
      type = _ref.type,
      ButtonImageElement = _ref.renderIcon,
      dangerDescription = _ref.dangerDescription,
      iconDescription = _ref.iconDescription,
      hasIconOnly = _ref.hasIconOnly,
      tooltipPosition = _ref.tooltipPosition,
      tooltipAlignment = _ref.tooltipAlignment,
      onClick = _ref.onClick,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      onMouseEnter = _ref.onMouseEnter,
      onMouseLeave = _ref.onMouseLeave,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      allowTooltipVisibility = _useState2[0],
      setAllowTooltipVisibility = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      isHovered = _useState4[0],
      setIsHovered = _useState4[1];

  var _useState5 = (0, _react.useState)(false),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      isFocused = _useState6[0],
      setIsFocused = _useState6[1];

  var tooltipRef = (0, _react.useRef)(null);
  var tooltipTimeout = (0, _react.useRef)(null);
  var prefix = (0, _usePrefix.usePrefix)();

  var closeTooltips = function closeTooltips(evt) {
    var _document;

    var tooltipNode = (_document = document) === null || _document === void 0 ? void 0 : _document.querySelectorAll(".".concat(prefix, "--tooltip--a11y"));
    (0, _toConsumableArray2.default)(tooltipNode).map(function (node) {
      (0, _toggleClass.default)(node, "".concat(prefix, "--tooltip--hidden"), node !== evt.currentTarget);
    });
  };

  var handleFocus = function handleFocus(evt) {
    if (hasIconOnly) {
      closeTooltips(evt);
      setIsFocused(true);
      setAllowTooltipVisibility(true);
    }
  };

  var handleBlur = function handleBlur() {
    if (hasIconOnly) {
      setIsHovered(false);
      setIsFocused(false);
      setAllowTooltipVisibility(false);
    }
  };

  var handleMouseEnter = function handleMouseEnter(evt) {
    if (hasIconOnly) {
      tooltipTimeout.current && clearTimeout(tooltipTimeout.current);

      if (evt.target === tooltipRef.current) {
        setAllowTooltipVisibility(true);
        return;
      }

      closeTooltips(evt);
      setAllowTooltipVisibility(true);
    }
  };

  var handleMouseLeave = function handleMouseLeave() {
    if (!isFocused && hasIconOnly) {
      tooltipTimeout.current = setTimeout(function () {
        setAllowTooltipVisibility(false);
        setIsHovered(false);
      }, 100);
    }
  };

  var handleClick = function handleClick(evt) {
    // Prevent clicks on the tooltip from triggering the button click event
    setAllowTooltipVisibility(false);

    if (evt.target === tooltipRef.current) {
      evt.preventDefault();
      return;
    }
  };

  (0, _react.useEffect)(function () {
    var handleEscKeyDown = function handleEscKeyDown(event) {
      if ((0, _keyboard.matches)(event, [_keyboard.keys.Escape])) {
        setAllowTooltipVisibility(false);
        setIsHovered(false);
      }
    };

    document.addEventListener('keydown', handleEscKeyDown);
    return function () {
      return document.removeEventListener('keydown', handleEscKeyDown);
    };
  }, []);
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var buttonClasses = (0, _classnames.default)(className, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn"), true), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--sm"), size === 'small' && !isExpressive || size === 'sm' && !isExpressive || small && !isExpressive), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--md"), size === 'field' && !isExpressive || size === 'md' && !isExpressive), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--lg"), enabled ? size === 'xl' : size === 'lg'), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--xl"), enabled ? size === '2xl' : size === 'xl'), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--").concat(kind), kind), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--disabled"), disabled), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--expressive"), isExpressive), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tooltip--visible"), !enabled && isHovered), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tooltip--hidden"), !enabled && hasIconOnly && !allowTooltipVisibility), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--icon-only"), hasIconOnly), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--selected"), hasIconOnly && isSelected && kind === 'ghost'), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tooltip__trigger"), !enabled && hasIconOnly), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tooltip--a11y"), !enabled && hasIconOnly), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--btn--icon-only--").concat(tooltipPosition), !enabled && hasIconOnly && tooltipPosition), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tooltip--align-").concat(tooltipAlignment), !enabled && hasIconOnly && tooltipAlignment), _classNames));
  var commonProps = {
    tabIndex: tabIndex,
    className: buttonClasses,
    ref: ref
  };
  var buttonImage = !ButtonImageElement ? null : /*#__PURE__*/_react.default.createElement(ButtonImageElement, {
    "aria-label": iconDescription,
    className: "".concat(prefix, "--btn__icon"),
    "aria-hidden": "true"
  });
  var dangerButtonVariants = ['danger', 'danger--tertiary', 'danger--ghost'];
  var component = 'button';
  var assistiveId = (0, _useId.useId)('danger-description');
  var otherProps = {
    disabled: disabled,
    type: type,
    'aria-describedby': dangerButtonVariants.includes(kind) ? assistiveId : null,
    'aria-pressed': hasIconOnly && kind === 'ghost' ? isSelected : null
  };
  var anchorProps = {
    href: href
  };
  var assistiveText;

  if (hasIconOnly) {
    assistiveText = /*#__PURE__*/_react.default.createElement("div", {
      ref: tooltipRef,
      onMouseEnter: handleMouseEnter,
      className: "".concat(prefix, "--assistive-text")
    }, iconDescription);
  } else if (dangerButtonVariants.includes(kind)) {
    assistiveText = /*#__PURE__*/_react.default.createElement("span", {
      id: assistiveId,
      className: "".concat(prefix, "--visually-hidden")
    }, dangerDescription);
  } else {
    assistiveText = null;
  }

  if (as) {
    component = as;
    otherProps = _objectSpread(_objectSpread({}, otherProps), anchorProps);
  } else if (href && !disabled) {
    component = 'a';
    otherProps = anchorProps;
  }

  if (enabled) {
    delete otherProps['aria-describedby'];
    return /*#__PURE__*/_react.default.createElement(component, _objectSpread(_objectSpread(_objectSpread({
      onMouseEnter: onMouseEnter,
      onMouseLeave: onMouseLeave,
      onFocus: onFocus,
      onBlur: onBlur,
      onClick: onClick,
      type: type
    }, other), commonProps), otherProps), children);
  }

  return /*#__PURE__*/_react.default.createElement(component, _objectSpread(_objectSpread(_objectSpread({
    onMouseEnter: (0, _events.composeEventHandlers)([onMouseEnter, handleMouseEnter]),
    onMouseLeave: (0, _events.composeEventHandlers)([onMouseLeave, handleMouseLeave]),
    onFocus: (0, _events.composeEventHandlers)([onFocus, handleFocus]),
    onBlur: (0, _events.composeEventHandlers)([onBlur, handleBlur]),
    onClick: (0, _events.composeEventHandlers)([onClick, handleClick])
  }, other), commonProps), otherProps), assistiveText, children, buttonImage);
});

Button.displayName = 'Button';
Button.propTypes = {
  /**
   * Specify how the button itself should be rendered.
   * Make sure to apply all props to the root node and render children appropriately
   */
  as: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Specify the content of your Button
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to your Button
   */
  className: _propTypes.default.string,

  /**
   * Specify the message read by screen readers for the danger button variant
   */
  dangerDescription: _propTypes.default.string,

  /**
   * Specify whether the Button should be disabled, or not
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify if the button is an icon-only button
   */
  hasIconOnly: _propTypes.default.bool,

  /**
   * Optionally specify an href for your Button to become an `<a>` element
   */
  href: _propTypes.default.string,

  /**
   * If specifying the `renderIcon` prop, provide a description for that icon that can
   * be read by screen readers
   */
  iconDescription: function iconDescription(props) {
    if (props.renderIcon && !props.children && !props.iconDescription) {
      return new Error('renderIcon property specified without also providing an iconDescription property.');
    }

    return undefined;
  },

  /**
   * Specify whether the Button is expressive, or not
   */
  isExpressive: _propTypes.default.bool,

  /**
   * Specify whether the Button is currently selected
   */
  isSelected: _propTypes.default.bool,

  /**
   * Specify the kind of Button you want to create
   */
  kind: _propTypes.default.oneOf(_types.ButtonKinds).isRequired,

  /**
   * Provide an optional function to be called when the button element
   * loses focus
   */
  onBlur: _propTypes.default.func,

  /**
   * Provide an optional function to be called when the button element
   * is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Provide an optional function to be called when the button element
   * receives focus
   */
  onFocus: _propTypes.default.func,

  /**
   * Provide an optional function to be called when the mouse
   * enters the button element
   */
  onMouseEnter: _propTypes.default.func,

  /**
   * Provide an optional function to be called when the mouse
   * leaves the button element
   */
  onMouseLeave: _propTypes.default.func,

  /**
   * Optional prop to allow overriding the icon rendering.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Optional prop to specify the role of the Button
   */
  role: _propTypes.default.string,

  /**
   * Specify the size of the button, from a list of available sizes.
   * For `default` buttons, this prop can remain unspecified or use `default`.
   * In the next major release of Carbon, `default`, `field`, and `small` will be removed
   */
  size: _propTypes.default.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg', 'xl', '2xl']),

  /**
   * Deprecated in v10 in favor of `size`.
   * Specify whether the Button should be a small variant
   */
  small: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `small` for Button has been deprecated in favor of `size`. Please use `size=\"sm\"` instead."),

  /**
   * Optional prop to specify the tabIndex of the Button
   */
  tabIndex: _propTypes.default.number,

  /**
   * Specify the alignment of the tooltip to the icon-only button.
   * Can be one of: start, center, or end.
   */
  tooltipAlignment: _propTypes.default.oneOf(['start', 'center', 'end']),

  /**
   * Specify the direction of the tooltip for icon-only buttons.
   * Can be either top, right, bottom, or left.
   */
  tooltipPosition: _propTypes.default.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * Optional prop to specify the type of the Button
   */
  type: _propTypes.default.oneOf(['button', 'reset', 'submit'])
};
Button.defaultProps = {
  tabIndex: 0,
  type: 'button',
  disabled: false,
  kind: 'primary',
  size: 'default',
  dangerDescription: 'danger',
  tooltipAlignment: 'center',
  tooltipPosition: 'top',
  isExpressive: false
};
var _default = Button;
exports.default = _default;