"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _ButtonSet = _interopRequireDefault(require("../ButtonSet"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
describe('ButtonSet', function () {
  var wrapper;
  beforeEach(function () {
    wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_ButtonSet.default, {
      className: "extra-class"
    }));
  });
  it('should render empty set as expected', function () {
    expect(wrapper.find('.child').length).toBe(0);
  });
  it('should render nonempty set as expected', function () {
    wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_ButtonSet.default, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "test-child"
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "test-child"
    })));
    expect(wrapper.find('.test-child').length).toBe(2);
  });
  it('should render wrapper as expected', function () {
    expect(wrapper.length).toBe(1);
  });
  it('should have the expected classes in a horizontal set', function () {
    expect(wrapper.hasClass("".concat(prefix, "--btn-set"))).toEqual(true);
  });
  it('should have the expected classes in a vertical set', function () {
    wrapper.setProps({
      stacked: true
    });
    expect(wrapper.hasClass("".concat(prefix, "--btn-set"))).toEqual(true);
    expect(wrapper.hasClass("".concat(prefix, "--btn-set--stacked"))).toEqual(true);
  });
});