"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.playground = exports.skeleton = exports.unstable_Checkbox = exports.checkbox = exports.checkboxNativeValidation = exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Checkbox = _interopRequireDefault(require("../Checkbox"));

var _Button = _interopRequireDefault(require("../../components/Button"));

var _Checkbox2 = _interopRequireDefault(require("../Checkbox/Checkbox.Skeleton"));

var _carbonComponents = require("carbon-components");

var _Checkbox3 = _interopRequireDefault(require("./Checkbox.mdx"));

var _FeatureFlags = require("../FeatureFlags");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
var _default = {
  title: 'Components/Checkbox',
  component: _Checkbox.default,
  subcomponents: {
    CheckboxSkeleton: _Checkbox2.default
  },
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _Checkbox3.default
    }
  }
};
exports.default = _default;

var checkboxNativeValidation = function checkboxNativeValidation() {
  function onSubmit(e) {
    e.preventDefault();
    var cb = e.target.querySelector('input[type=checkbox]');

    if (cb.checked === false) {
      cb.setCustomValidity('Privacy policy has to be accepted.');
      cb.reportValidity();
      return;
    }

    alert('submitted');
  }

  function onChange(e) {
    e.target.setCustomValidity('');
  }

  return /*#__PURE__*/_react.default.createElement("form", {
    style: {
      margin: '2em'
    },
    onSubmit: onSubmit,
    onChange: onChange
  }, /*#__PURE__*/_react.default.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Validation example"), /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
    id: "cb",
    labelText: "Accept privacy policy"
  }), /*#__PURE__*/_react.default.createElement(_Button.default, {
    type: "submit"
  }, "Submit"));
};

exports.checkboxNativeValidation = checkboxNativeValidation;

var checkbox = function checkbox() {
  return /*#__PURE__*/_react.default.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/_react.default.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
    labelText: "Checkbox label",
    id: "checkbox-label-1"
  }), /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
    labelText: "Checkbox label",
    id: "checkbox-label-2"
  }));
};

exports.checkbox = checkbox;

var unstable_Checkbox = function unstable_Checkbox() {
  return /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/_react.default.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/_react.default.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), /*#__PURE__*/_react.default.createElement(_Checkbox.default, (0, _extends2.default)({}, props(), {
    labelText: "Checkbox label",
    id: "checkbox-label-1"
  })), /*#__PURE__*/_react.default.createElement(_Checkbox.default, (0, _extends2.default)({}, props(), {
    labelText: "Checkbox label",
    id: "checkbox-label-2"
  }))));
};

exports.unstable_Checkbox = unstable_Checkbox;
unstable_Checkbox.story = {
  name: 'unstable_Checkbox'
};

var skeleton = function skeleton() {
  return /*#__PURE__*/_react.default.createElement(_Checkbox2.default, null);
};

exports.skeleton = skeleton;

var props = function props() {
  return {
    checked: (0, _addonKnobs.boolean)('Checked (checked)', false),
    className: 'some-class',
    labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Checkbox label'),
    indeterminate: (0, _addonKnobs.boolean)('Intermediate (indeterminate)', false),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel)', false),
    wrapperClassName: (0, _addonKnobs.text)('Wrapper CSS class name (wrapperClassName)', ''),
    onChange: (0, _addonActions.action)('onChange')
  };
};

var playground = function playground() {
  return /*#__PURE__*/_react.default.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/_react.default.createElement("legend", {
    className: (0, _classnames.default)("".concat(prefix, "--label"), (0, _defineProperty2.default)({}, "".concat(prefix, "--label--disabled"), props().disabled))
  }, "Checkbox heading"), /*#__PURE__*/_react.default.createElement(_Checkbox.default, (0, _extends2.default)({}, props(), {
    id: "checkbox-label-1"
  })), /*#__PURE__*/_react.default.createElement(_Checkbox.default, (0, _extends2.default)({}, props(), {
    id: "checkbox-label-2"
  })));
};

exports.playground = playground;