"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _react = _interopRequireDefault(require("react"));

var _Checkbox = _interopRequireDefault(require("../Checkbox"));

var _Checkbox2 = _interopRequireDefault(require("../Checkbox/Checkbox.Skeleton"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
describe('Checkbox', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      id: "testing",
      labelText: "testingLabel",
      className: "extra-class"
    }));
    var label = wrapper.find('label');
    describe('label', function () {
      it('renders a label', function () {
        expect(label.length).toEqual(1);
      });
      it('has the expected classes', function () {
        expect(label.hasClass("".concat(prefix, "--checkbox-label"))).toEqual(true);
      });
      it('has the expected htmlFor value', function () {
        expect(label.props().htmlFor).toEqual('testing');
      });
      it('applies extra classes to label', function () {
        expect(label.hasClass('extra-class')).toEqual(true);
      });
      describe('input', function () {
        var input = function input() {
          return wrapper.find('input');
        };

        it('has id set as expected', function () {
          expect(input().props().id).toEqual('testing');
        });
        it('defaultChecked prop sets defaultChecked on input', function () {
          expect(input().props().defaultChecked).toBeUndefined();
          wrapper.setProps({
            defaultChecked: true
          });
          expect(input().props().defaultChecked).toEqual(true);
        });
      });
    });
  });
  it('disabled prop on component sets disabled prop on input', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      id: "test",
      labelText: "testlabel",
      disabled: true
    }));

    var input = function input() {
      return wrapper.find('input');
    };

    expect(input().props().disabled).toEqual(true);
    wrapper.setProps({
      disabled: false
    });
    expect(input().props().disabled).toEqual(false);
  });
  it('checked prop on component sets checked prop on input', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      id: "test",
      labelText: "testlabel",
      checked: true
    }));

    var input = function input() {
      return wrapper.find('input');
    };

    expect(input().props().checked).toEqual(true);
    wrapper.setProps({
      checked: false
    });
    expect(input().props().checked).toEqual(false);
  });
  it('hideLabel hides the label visually', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      id: "test",
      labelText: "testlabel",
      hideLabel: true
    }));
    var label = wrapper.find('label');
    expect(label.length).toEqual(1);
    var span = wrapper.find('span');
    expect(span.hasClass("".concat(prefix, "--visually-hidden"))).toEqual(true);
  });
  describe('events', function () {
    it('should invoke onChange with expected arguments', function () {
      var onChange = jest.fn();
      var id = 'test-input';
      var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
        labelText: "testlabel",
        id: id,
        onChange: onChange
      }));
      var input = wrapper.find('input');
      var inputElement = input.instance();
      inputElement.checked = true;
      wrapper.find('input').simulate('change');
      var call = onChange.mock.calls[0];
      expect(call[0]).toEqual(true);
      expect(call[1]).toEqual(id);
      expect(call[2].target).toBe(inputElement);
    });
  });
});
describe('refs', function () {
  var container;
  afterEach(function () {
    if (container && container.parentNode) {
      container.parentNode.removeChild(container);
    }

    container = null;
  });
  it('should accept refs', function () {
    var MyComponent = /*#__PURE__*/function (_React$Component) {
      (0, _inherits2.default)(MyComponent, _React$Component);

      var _super = _createSuper(MyComponent);

      function MyComponent(props) {
        var _this;

        (0, _classCallCheck2.default)(this, MyComponent);
        _this = _super.call(this, props);
        _this.myRef = /*#__PURE__*/_react.default.createRef();
        _this.focus = _this.focus.bind((0, _assertThisInitialized2.default)(_this));
        return _this;
      }

      (0, _createClass2.default)(MyComponent, [{
        key: "focus",
        value: function focus() {
          this.myRef.current.focus();
        }
      }, {
        key: "render",
        value: function render() {
          return /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
            id: "test",
            labelText: "testlabel",
            hideLabel: true,
            ref: this.myRef
          });
        }
      }]);
      return MyComponent;
    }(_react.default.Component);

    container = document.createElement('div');
    container.id = 'container';
    document.body.appendChild(container);
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(MyComponent, null), {
      attachTo: document.querySelector('#container')
    });
    expect(document.activeElement.type).toBeUndefined();
    wrapper.instance().focus();
    expect(document.activeElement.type).toEqual('checkbox');
  });
  it('should set indeterminate when accepting refs', function () {
    var MyComponent = /*#__PURE__*/function (_React$Component2) {
      (0, _inherits2.default)(MyComponent, _React$Component2);

      var _super2 = _createSuper(MyComponent);

      function MyComponent(props) {
        var _this2;

        (0, _classCallCheck2.default)(this, MyComponent);
        _this2 = _super2.call(this, props);
        _this2.myRef = /*#__PURE__*/_react.default.createRef();
        return _this2;
      }

      (0, _createClass2.default)(MyComponent, [{
        key: "render",
        value: function render() {
          return /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
            id: "test-id",
            labelText: "test",
            indeterminate: true,
            ref: this.myRef
          });
        }
      }]);
      return MyComponent;
    }(_react.default.Component);

    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(MyComponent, null));
    expect(wrapper.find('input').getDOMNode().indeterminate).toBe(true);
  });
});
describe('CheckboxSkeleton', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Checkbox2.default, null));
    var label = wrapper.find('span');
    describe('label', function () {
      it('renders a label', function () {
        expect(label.length).toEqual(1);
      });
      it('has the expected classes', function () {
        expect(label.hasClass("".concat(prefix, "--checkbox-label-text"))).toEqual(true);
        expect(label.hasClass("".concat(prefix, "--skeleton"))).toEqual(true);
      });
    });
  });
});
describe('Checkbox accessibility', function () {
  afterEach(_react2.cleanup);
  it('should have no Axe violations', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
              labelText: "Checkbox label",
              id: "test_id"
            }));
            _context.next = 3;
            return expect(_react2.screen.getByLabelText('Checkbox label')).toHaveNoAxeViolations();

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
  it('should have no Accessibility Checker violations', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
    return _regenerator.default.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement("main", null, /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
              labelText: "Checkbox label",
              id: "test_id"
            })));
            _context2.next = 3;
            return expect(_react2.screen.getByLabelText('Checkbox label')).toHaveNoACViolations('Checkbox');

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  })));
  it('can receive keyboard focus', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      labelText: "Checkbox label",
      id: "test_id"
    }));

    _userEvent.default.tab();

    expect(_react2.screen.getByLabelText('Checkbox label')).toHaveFocus();
  });
  it('should have an accessible label', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      labelText: "Checkbox label",
      id: "test_id"
    }));
    expect(function () {
      return _react2.screen.getByText('Checkbox label');
    }).not.toThrow();
  });
  it('should have an appropriate role', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      labelText: "Checkbox label",
      id: "test_id"
    }));
    expect(function () {
      return _react2.screen.getByRole('checkbox');
    }).not.toThrow();
  });
});