"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Text = require("../Text");

var _FeatureFlags = require("../FeatureFlags");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "id", "labelText", "onChange", "indeterminate", "hideLabel", "wrapperClassName", "title"];

var Checkbox = /*#__PURE__*/_react.default.forwardRef(function Checkbox(_ref, _ref2) {
  var className = _ref.className,
      id = _ref.id,
      labelText = _ref.labelText,
      _onChange = _ref.onChange,
      indeterminate = _ref.indeterminate,
      hideLabel = _ref.hideLabel,
      wrapperClassName = _ref.wrapperClassName,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var prefix = (0, _usePrefix.usePrefix)();
  var labelClasses = (0, _classnames.default)("".concat(prefix, "--checkbox-label"), [enabled ? null : className]);
  var innerLabelClasses = (0, _classnames.default)("".concat(prefix, "--checkbox-label-text"), (0, _defineProperty2.default)({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--form-item"), "".concat(prefix, "--checkbox-wrapper"), [enabled ? className : wrapperClassName]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, other, {
    type: "checkbox",
    onChange: function onChange(evt) {
      if (enabled) {
        _onChange(evt, {
          checked: evt.target.checked,
          id: id
        });
      } else {
        _onChange(evt.target.checked, id, evt);
      }
    },
    className: "".concat(prefix, "--checkbox"),
    id: id,
    ref: function ref(el) {
      if (el) {
        el.indeterminate = indeterminate;
      }

      if (typeof _ref2 === 'function') {
        _ref2(el);
      } else if (Object(_ref2) === _ref2) {
        _ref2.current = el;
      }
    }
  })), /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: labelClasses,
    title: title || null
  }, /*#__PURE__*/_react.default.createElement(_Text.Text, {
    className: innerLabelClasses
  }, labelText)));
});

Checkbox.propTypes = {
  /**
   * Specify whether the underlying input should be checked
   */
  checked: _propTypes.default.bool,

  /**
   * Specify an optional className to be applied to the <label> node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the underlying input should be checked by default
   */
  defaultChecked: _propTypes.default.bool,

  /**
   * Specify whether the Checkbox should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Provide an `id` to uniquely identify the Checkbox input
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify whether the Checkbox is in an indeterminate state
   */
  indeterminate: _propTypes.default.bool,

  /**
   * Provide a label to provide a description of the Checkbox input that you are
   * exposing to the user
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Receives three arguments: true/false, the checkbox's id, and the dom event.
   * `(value, id, event) => console.log({value, id, event})`
   */
  onChange: _propTypes.default.func,

  /**
   * Specify a title for the <label> node for the Checkbox
   */
  title: _propTypes.default.string,

  /**
   * The CSS class name to be placed on the wrapping element
   */
  wrapperClassName: (0, _deprecate.default)(_propTypes.default.string, "\nThe prop `wrapperClassName` for Checkbox will be deprecated in V11 in favor of `className`. `className` will then be placed on the outer wrapper.")
};
Checkbox.defaultProps = {
  onChange: function onChange() {},
  indeterminate: false
};
Checkbox.displayName = 'Checkbox';
var _default = Checkbox;
exports.default = _default;