"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.playground = exports.skeleton = exports.singleline = exports.multiline = exports.inline = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _CodeSnippet = _interopRequireDefault(require("../CodeSnippet"));

var _CodeSnippet2 = _interopRequireDefault(require("./CodeSnippet.Skeleton"));

var _CodeSnippet3 = _interopRequireDefault(require("./CodeSnippet.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/CodeSnippet',
  component: _CodeSnippet.default,
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _CodeSnippet3.default
    },
    knobs: {
      escapeHTML: false
    }
  }
};
exports.default = _default;
var multiSnippet = "\"scripts\": {\n    \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n    \"ci-check\": \"carbon-cli ci-check\",\n    \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n    \"doctoc\": \"doctoc --title '## Table of Contents'\",\n    \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n    \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n    \"lint\": \"eslint actions config codemods packages\",\n    \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n    \"sync\": \"carbon-cli sync\",\n    \"test\": \"cross-env BABEL_ENV=test jest\",\n    \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n  },\n  \"resolutions\": {\n    \"react\": \"~16.9.0\",\n    \"react-dom\": \"~16.9.0\",\n    \"react-is\": \"~16.9.0\",\n    \"react-test-renderer\": \"~16.9.0\"\n  },\n  \"devDependencies\": {\n    \"@babel/core\": \"^7.10.0\",\n    \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n    \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n    \"@babel/preset-env\": \"^7.10.0\",\n    \"@babel/preset-react\": \"^7.10.0\",\n    \"@babel/runtime\": \"^7.10.0\",\n    \"@commitlint/cli\": \"^8.3.5\",";
var shortSnippet = "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest";
var inlineSnippet = "node -v";

var snippetText = function snippetText() {
  return {
    inline: (0, _addonKnobs.text)('Text to be displayed in the inline CodeSnippet', inlineSnippet),
    single: (0, _addonKnobs.text)('Text to be displayed in the single-line CodeSnippet', shortSnippet),
    multi: (0, _addonKnobs.text)('Text to be displayed in the multi-line CodeSnippet', multiSnippet)
  };
};

var props = function props() {
  return {
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    feedback: (0, _addonKnobs.text)('Feedback text (feedback)', 'Copied'),
    feedbackTimeout: (0, _addonKnobs.number)('Feedback text timeout (feedbackTimeout)', 2000),
    showMoreText: (0, _addonKnobs.text)('Text for "show more" button (showMoreText)', 'Show more'),
    showLessText: (0, _addonKnobs.text)('Text for "show less" button (showLessText)', 'Show less'),
    hideCopyButton: (0, _addonKnobs.boolean)('Hide copy button (hideCopyButton)', false),
    onClick: (0, _addonActions.action)('onClick'),
    copyButtonDescription: (0, _addonKnobs.text)('Copy button title (copyButtonDescription)', 'Copy code snippet'),
    ariaLabel: (0, _addonKnobs.text)('ARIA label (ariaLabel)', 'Container label'),
    wrapText: (0, _addonKnobs.boolean)('Wrap text (wrapText)', true),
    maxCollapsedNumberOfRows: (0, _addonKnobs.number)('Maximum number of rows to be shown when collapsed (maxCollapsedNumberOfRows)', 15),
    maxExpandedNumberOfRows: (0, _addonKnobs.number)('Maximum number of rows to be shown when expanded (maxExpandedNumberOfRows)', 0),
    minCollapsedNumberOfRows: (0, _addonKnobs.number)('Minimum number of rows to be shown when collapsed (minCollapsedNumberOfRows)', 3),
    minExpandedNumberOfRows: (0, _addonKnobs.number)('Minimum number of rows to be shown when expanded (minExpandedNumberOfRows)', 16)
  };
};

var inline = function inline() {
  return /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v');
};

exports.inline = inline;

var multiline = function multiline() {
  return /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n    \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n    \"ci-check\": \"carbon-cli ci-check\",\n    \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n    \"doctoc\": \"doctoc --title '## Table of Contents'\",\n    \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n    \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n    \"lint\": \"eslint actions config codemods packages\",\n    \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n    \"sync\": \"carbon-cli sync\",\n    \"test\": \"cross-env BABEL_ENV=test jest\",\n    \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n  },\n  \"resolutions\": {\n    \"react\": \"~16.9.0\",\n    \"react-dom\": \"~16.9.0\",\n    \"react-is\": \"~16.9.0\",\n    \"react-test-renderer\": \"~16.9.0\"\n  },\n  \"devDependencies\": {\n    \"@babel/core\": \"^7.10.0\",\n    \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n    \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n    \"@babel/preset-env\": \"^7.10.0\",\n    \"@babel/preset-react\": \"^7.10.0\",\n    \"@babel/runtime\": \"^7.10.0\",\n    \"@commitlint/cli\": \"^8.3.5\",");
};

exports.multiline = multiline;

var singleline = function singleline() {
  return /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest");
};

exports.singleline = singleline;

var skeleton = function skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_CodeSnippet2.default, {
    type: "single",
    style: {
      marginBottom: 8
    }
  }), /*#__PURE__*/_react.default.createElement(_CodeSnippet2.default, {
    type: "multi"
  }));
};

exports.skeleton = skeleton;

var lightPropMessage = /*#__PURE__*/_react.default.createElement("small", {
  style: {
    display: 'block',
    paddingBottom: '1rem'
  }
}, "The snippet container should never be the same color as the page background.", /*#__PURE__*/_react.default.createElement("br", null), 'Do not use the ', /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, {
  type: "inline",
  light: true
}, "light"), ' variant on ', /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, {
  type: "inline",
  light: true
}, "$ui-background"), ' or ', /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, {
  type: "inline",
  light: true
}, "$ui-02"), ".");

var playground = function playground() {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: props().light ? 'bx--tile' : ''
  }, props().light && lightPropMessage, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("h4", null, "Inline snippet"), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, (0, _extends2.default)({
    type: "inline"
  }, props()), snippetText().inline), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("h4", null, "Single-line snippet"), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, (0, _extends2.default)({
    type: "single"
  }, props()), snippetText().single), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("h4", null, "Multi-line snippet"), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_CodeSnippet.default, (0, _extends2.default)({
    type: "multi"
  }, props()), snippetText().multi));
};

exports.playground = playground;