"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "type"];

function CodeSnippetSkeleton(_ref) {
  var _cx;

  var containerClassName = _ref.className,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'single' : _ref$type,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)(containerClassName, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--snippet"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--skeleton"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--snippet--single"), type === 'single'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--snippet--multi"), type === 'multi'), _cx));

  if (type === 'single') {
    return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
      className: className
    }, rest), /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--snippet-container")
    }, /*#__PURE__*/_react.default.createElement("span", null)));
  }

  if (type === 'multi') {
    return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
      className: className
    }, rest), /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--snippet-container")
    }, /*#__PURE__*/_react.default.createElement("span", null), /*#__PURE__*/_react.default.createElement("span", null), /*#__PURE__*/_react.default.createElement("span", null)));
  }
}

CodeSnippetSkeleton.propTypes = {
  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * The type of the code snippet, including single or multi
   */
  type: _propTypes.default.oneOf(['single', 'multi'])
};
var _default = CodeSnippetSkeleton;
exports.default = _default;