"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalBody = ModalBody;
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _ModalHeader = require("./ModalHeader");

var _ComposedModal = require("../ComposedModal");

var _classnames = _interopRequireDefault(require("classnames"));

var _toggleClass = _interopRequireDefault(require("../../../tools/toggleClass"));

var _requiredIfGivenPropIsTruthy = _interopRequireDefault(require("../../../prop-types/requiredIfGivenPropIsTruthy"));

var _wrapFocus = _interopRequireDefault(require("../../../internal/wrapFocus"));

var _usePrefix = require("../../../internal/usePrefix");

var _ModalBody$propTypes, _ComposedModal$propTy;

var _excluded = ["className", "children", "hasForm", "hasScrollingContent"],
    _excluded2 = ["aria-labelledby", "aria-label", "children", "className", "containerClassName", "danger", "onClose", "onKeyDown", "open", "preventCloseOnClickOutside", "selectorPrimaryFocus", "selectorsFloatingMenus", "size"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ModalBody(_ref) {
  var _cx;

  var customClassName = _ref.className,
      children = _ref.children,
      hasForm = _ref.hasForm,
      hasScrollingContent = _ref.hasScrollingContent,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var contentClass = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--modal-content"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--modal-content--with-form"), hasForm), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--modal-scroll-content"), hasScrollingContent), (0, _defineProperty2.default)(_cx, customClassName, customClassName), _cx));
  var hasScrollingContentProps = hasScrollingContent ? {
    tabIndex: 0,
    role: 'region'
  } : {};
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: contentClass
  }, hasScrollingContentProps, rest), children), hasScrollingContent && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--modal-content--overflow-indicator")
  }));
}

ModalBody.propTypes = (_ModalBody$propTypes = {}, (0, _defineProperty2.default)(_ModalBody$propTypes, 'aria-label', (0, _requiredIfGivenPropIsTruthy.default)('hasScrollingContent', _propTypes.default.string)), (0, _defineProperty2.default)(_ModalBody$propTypes, "children", _propTypes.default.node), (0, _defineProperty2.default)(_ModalBody$propTypes, "className", _propTypes.default.string), (0, _defineProperty2.default)(_ModalBody$propTypes, "hasForm", _propTypes.default.bool), (0, _defineProperty2.default)(_ModalBody$propTypes, "hasScrollingContent", _propTypes.default.bool), _ModalBody$propTypes);

var ComposedModal = /*#__PURE__*/_react.default.forwardRef(function ComposedModal(_ref2, ref) {
  var _cx2, _cx3;

  var ariaLabelledBy = _ref2['aria-labelledby'],
      ariaLabel = _ref2['aria-label'],
      children = _ref2.children,
      customClassName = _ref2.className,
      containerClassName = _ref2.containerClassName,
      danger = _ref2.danger,
      onClose = _ref2.onClose,
      onKeyDown = _ref2.onKeyDown,
      open = _ref2.open,
      preventCloseOnClickOutside = _ref2.preventCloseOnClickOutside,
      selectorPrimaryFocus = _ref2.selectorPrimaryFocus,
      selectorsFloatingMenus = _ref2.selectorsFloatingMenus,
      size = _ref2.size,
      rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var prefix = (0, _usePrefix.usePrefix)();

  var _useState = (0, _react.useState)(open),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isOpen = _useState2[0],
      setisOpen = _useState2[1];

  var _useState3 = (0, _react.useState)(open),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      prevOpen = _useState4[0],
      setPrevOpen = _useState4[1];

  var innerModal = (0, _react.useRef)();
  var button = (0, _react.useRef)();
  var startSentinel = (0, _react.useRef)();
  var endSentinel = (0, _react.useRef)();

  if (open !== prevOpen) {
    setisOpen(open);
    setPrevOpen(open);
  }

  function handleKeyDown(evt) {
    // Esc key
    if (evt.which === 27) {
      closeModal(evt);
    }

    onKeyDown(evt);
  }

  function handleClick(evt) {
    if (!innerModal.current.contains(evt.target) && preventCloseOnClickOutside) {
      return;
    }

    if (innerModal.current && !innerModal.current.contains(evt.target)) {
      closeModal(evt);
    }
  }

  function handleBlur(_ref3) {
    var oldActiveNode = _ref3.target,
        currentActiveNode = _ref3.relatedTarget;

    if (open && currentActiveNode && oldActiveNode) {
      var bodyNode = innerModal.current;
      var startSentinelNode = startSentinel.current;
      var endSentinelNode = endSentinel.current;
      (0, _wrapFocus.default)({
        bodyNode: bodyNode,
        startSentinelNode: startSentinelNode,
        endSentinelNode: endSentinelNode,
        currentActiveNode: currentActiveNode,
        oldActiveNode: oldActiveNode,
        selectorsFloatingMenus: selectorsFloatingMenus
      });
    }
  }

  function closeModal(evt) {
    if (!onClose || onClose(evt) !== false) {
      setisOpen(false);
    }
  }

  var modalClass = (0, _classnames.default)((_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--modal"), true), (0, _defineProperty2.default)(_cx2, 'is-visible', isOpen), (0, _defineProperty2.default)(_cx2, customClassName, customClassName), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--modal--danger"), danger), _cx2));
  var containerClass = (0, _classnames.default)((_cx3 = {}, (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--modal-container"), true), (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--modal-container--").concat(size), size), (0, _defineProperty2.default)(_cx3, containerClassName, containerClassName), _cx3)); // Generate aria-label based on Modal Header label if one is not provided (L253)

  var generatedAriaLabel;

  var childrenWithProps = _react.default.Children.toArray(children).map(function (child) {
    switch (child.type) {
      case /*#__PURE__*/_react.default.createElement(_ModalHeader.ModalHeader).type:
        generatedAriaLabel = child.props.label;
        return /*#__PURE__*/_react.default.cloneElement(child, {
          closeModal: closeModal
        });

      case /*#__PURE__*/_react.default.createElement(_ComposedModal.ModalFooter).type:
        return /*#__PURE__*/_react.default.cloneElement(child, {
          closeModal: closeModal,
          inputref: button
        });

      default:
        return child;
    }
  });

  (0, _react.useEffect)(function () {
    if (prevOpen !== isOpen) {
      (0, _toggleClass.default)(document.body, "".concat(prefix, "--body--with-modal-open"), isOpen);
    }
  });
  (0, _react.useEffect)(function () {
    return function () {
      return (0, _toggleClass.default)(document.body, "".concat(prefix, "--body--with-modal-open"), false);
    };
  });
  (0, _react.useEffect)(function () {
    (0, _toggleClass.default)(document.body, "".concat(prefix, "--body--with-modal-open"), open);
  }, [open, prefix]);
  (0, _react.useEffect)(function () {
    var focusButton = function focusButton(focusContainerElement) {
      if (focusContainerElement) {
        var primaryFocusElement = focusContainerElement.querySelector(selectorPrimaryFocus);

        if (primaryFocusElement) {
          primaryFocusElement.focus();
          return;
        }

        if (button.current) {
          button.current.focus();
        }
      }
    };

    if (!open) {
      return;
    }

    if (innerModal.current) {
      focusButton(innerModal.current);
    }
  }, [open, selectorPrimaryFocus]);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    role: "presentation",
    ref: ref,
    onBlur: handleBlur,
    onClick: handleClick,
    onKeyDown: handleKeyDown,
    className: modalClass
  }), /*#__PURE__*/_react.default.createElement("span", {
    ref: startSentinel,
    tabIndex: "0",
    role: "link",
    className: "".concat(prefix, "--visually-hidden")
  }, "Focus sentinel"), /*#__PURE__*/_react.default.createElement("div", {
    ref: innerModal,
    className: containerClass,
    role: "dialog",
    "aria-modal": "true",
    "aria-label": ariaLabel ? ariaLabel : generatedAriaLabel,
    "aria-labelledby": ariaLabelledBy
  }, childrenWithProps), /*#__PURE__*/_react.default.createElement("span", {
    ref: endSentinel,
    tabIndex: "0",
    role: "link",
    className: "".concat(prefix, "--visually-hidden")
  }, "Focus sentinel"));
});

ComposedModal.propTypes = (_ComposedModal$propTy = {}, (0, _defineProperty2.default)(_ComposedModal$propTy, 'aria-label', _propTypes.default.string), (0, _defineProperty2.default)(_ComposedModal$propTy, 'aria-labelledby', _propTypes.default.string), (0, _defineProperty2.default)(_ComposedModal$propTy, "children", _propTypes.default.node), (0, _defineProperty2.default)(_ComposedModal$propTy, "className", _propTypes.default.string), (0, _defineProperty2.default)(_ComposedModal$propTy, "containerClassName", _propTypes.default.string), (0, _defineProperty2.default)(_ComposedModal$propTy, "danger", _propTypes.default.bool), (0, _defineProperty2.default)(_ComposedModal$propTy, "onClose", _propTypes.default.func), (0, _defineProperty2.default)(_ComposedModal$propTy, "onKeyDown", _propTypes.default.func), (0, _defineProperty2.default)(_ComposedModal$propTy, "open", _propTypes.default.bool), (0, _defineProperty2.default)(_ComposedModal$propTy, "preventCloseOnClickOutside", _propTypes.default.bool), (0, _defineProperty2.default)(_ComposedModal$propTy, "selectorPrimaryFocus", _propTypes.default.string), (0, _defineProperty2.default)(_ComposedModal$propTy, "selectorsFloatingMenus", _propTypes.default.string), (0, _defineProperty2.default)(_ComposedModal$propTy, "size", _propTypes.default.oneOf(['xs', 'sm', 'md', 'lg'])), _ComposedModal$propTy);
ComposedModal.defaultProps = {
  onKeyDown: function onKeyDown() {},
  selectorPrimaryFocus: '[data-modal-primary-focus]'
};
var _default = ComposedModal;
exports.default = _default;