"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalFooter = ModalFooter;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Button = _interopRequireDefault(require("../../Button"));

var _ButtonSet = _interopRequireDefault(require("../../ButtonSet"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../../internal/usePrefix");

var _excluded = ["children", "className", "closeModal", "danger", "inputref", "onRequestClose", "onRequestSubmit", "primaryButtonDisabled", "primaryButtonText", "primaryClassName", "secondaryButtonText", "secondaryButtons", "secondaryClassName"];

function SecondaryButtonSet(_ref) {
  var secondaryButtons = _ref.secondaryButtons,
      secondaryButtonText = _ref.secondaryButtonText,
      secondaryClassName = _ref.secondaryClassName,
      closeModal = _ref.closeModal,
      onRequestClose = _ref.onRequestClose;

  function handleRequestClose(evt) {
    closeModal(evt);
    onRequestClose(evt);
  }

  if (Array.isArray(secondaryButtons) && secondaryButtons.length <= 2) {
    return secondaryButtons.map(function (_ref2, i) {
      var buttonText = _ref2.buttonText,
          onButtonClick = _ref2.onClick;
      return /*#__PURE__*/_react.default.createElement(_Button.default, {
        key: "".concat(buttonText, "-").concat(i),
        className: secondaryClassName,
        kind: "secondary",
        onClick: onButtonClick || handleRequestClose
      }, buttonText);
    });
  }

  if (secondaryButtonText) {
    return /*#__PURE__*/_react.default.createElement(_Button.default, {
      className: secondaryClassName,
      onClick: handleRequestClose,
      kind: "secondary"
    }, secondaryButtonText);
  }

  return null;
}

SecondaryButtonSet.propTypes = {
  closeModal: _propTypes.default.func,
  onRequestClose: _propTypes.default.func,
  secondaryButtonText: _propTypes.default.string,
  secondaryButtons: function secondaryButtons(props, propName, componentName) {
    if (props.secondaryButtons) {
      if (!Array.isArray(props.secondaryButtons) || props.secondaryButtons.length !== 2) {
        return new Error("".concat(propName, " needs to be an array of two button config objects"));
      }

      var shape = {
        buttonText: _propTypes.default.node,
        onClick: _propTypes.default.func
      };
      props[propName].forEach(function (secondaryButton) {
        _propTypes.default.checkPropTypes(shape, secondaryButton, propName, componentName);
      });
    }

    return null;
  },
  secondaryClassName: _propTypes.default.string
};

function ModalFooter(_ref3) {
  var _cx;

  var children = _ref3.children,
      customClassName = _ref3.className,
      closeModal = _ref3.closeModal,
      danger = _ref3.danger,
      inputref = _ref3.inputref,
      onRequestClose = _ref3.onRequestClose,
      onRequestSubmit = _ref3.onRequestSubmit,
      primaryButtonDisabled = _ref3.primaryButtonDisabled,
      primaryButtonText = _ref3.primaryButtonText,
      primaryClassName = _ref3.primaryClassName,
      secondaryButtonText = _ref3.secondaryButtonText,
      secondaryButtons = _ref3.secondaryButtons,
      secondaryClassName = _ref3.secondaryClassName,
      rest = (0, _objectWithoutProperties2.default)(_ref3, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var footerClass = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--modal-footer"), true), (0, _defineProperty2.default)(_cx, customClassName, customClassName), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--modal-footer--three-button"), Array.isArray(secondaryButtons) && secondaryButtons.length === 2), _cx));
  var secondaryButtonProps = {
    closeModal: closeModal,
    secondaryButtons: secondaryButtons,
    secondaryButtonText: secondaryButtonText,
    secondaryClassName: secondaryClassName,
    onRequestClose: onRequestClose
  };
  return /*#__PURE__*/_react.default.createElement(_ButtonSet.default, (0, _extends2.default)({
    className: footerClass
  }, rest), /*#__PURE__*/_react.default.createElement(SecondaryButtonSet, secondaryButtonProps), primaryButtonText && /*#__PURE__*/_react.default.createElement(_Button.default, {
    onClick: onRequestSubmit,
    className: primaryClassName,
    disabled: primaryButtonDisabled,
    kind: danger ? 'danger' : 'primary',
    ref: inputref
  }, primaryButtonText), children);
}

ModalFooter.propTypes = {
  /**
   * Pass in content that will be rendered in the Modal Footer
   */
  children: _propTypes.default.node,

  /**
   * Specify a custom className to be applied to the Modal Footer container
   */
  className: _propTypes.default.string,

  /**
   * Specify an optional function that is called whenever the modal is closed
   */
  closeModal: _propTypes.default.func,

  /**
   * Specify whether the primary button should be replaced with danger button.
   * Note that this prop is not applied if you render primary/danger button by yourself
   */
  danger: _propTypes.default.bool,

  /**
   * The `ref` callback for the primary button.
   */
  inputref: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.shape({
    current: _propTypes.default.any
  })]),

  /**
   * Specify an optional function for when the modal is requesting to be
   * closed
   */
  onRequestClose: _propTypes.default.func,

  /**
   * Specify an optional function for when the modal is requesting to be
   * submitted
   */
  onRequestSubmit: _propTypes.default.func,

  /**
   * Specify whether the primary button should be disabled
   */
  primaryButtonDisabled: _propTypes.default.bool,

  /**
   * Specify the text for the primary button
   */
  primaryButtonText: _propTypes.default.string,

  /**
   * Specify a custom className to be applied to the primary button
   */
  primaryClassName: _propTypes.default.string,

  /**
   * Specify the text for the secondary button
   */
  secondaryButtonText: _propTypes.default.string,

  /**
   * Specify an array of config objects for secondary buttons
   * (`Array<{
   *   buttonText: string,
   *   onClick: function,
   * }>`).
   */
  secondaryButtons: function secondaryButtons(props, propName, componentName) {
    if (props.secondaryButtons) {
      if (!Array.isArray(props.secondaryButtons) || props.secondaryButtons.length !== 2) {
        return new Error("".concat(propName, " needs to be an array of two button config objects"));
      }

      var shape = {
        buttonText: _propTypes.default.node,
        onClick: _propTypes.default.func
      };
      props[propName].forEach(function (secondaryButton) {
        _propTypes.default.checkPropTypes(shape, secondaryButton, propName, componentName);
      });
    }

    return null;
  },

  /**
   * Specify a custom className to be applied to the secondary button
   */
  secondaryClassName: _propTypes.default.string
};
ModalFooter.defaultProps = {
  onRequestClose: function onRequestClose() {},
  onRequestSubmit: function onRequestSubmit() {},
  closeModal: function closeModal() {}
};