"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._MultipleGroups = exports._ContextMenu = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Notification = require("../Notification");

var _Menu = _interopRequireDefault(require("../Menu"));

var _storybookUtils = require("../Menu/_storybook-utils");

var _index = require("./index");

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Experimental/unstable_Menu/ContextMenu',
  parameters: {
    component: _Menu.default
  }
};
exports.default = _default;

var Story = function Story(items) {
  var menuProps = (0, _index.useContextMenu)();
  var renderedItems = (0, _storybookUtils.buildMenu)(items);
  return /*#__PURE__*/_react.default.createElement(_storybookUtils.StoryFrame, null, /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
    kind: "info",
    title: "Context menu",
    subtitle: "Right-click anywhere on this page to access an example implementation of this component.",
    lowContrast: true,
    hideCloseButton: true
  }), /*#__PURE__*/_react.default.createElement(_Menu.default, menuProps, renderedItems));
};

var _ContextMenu = function _ContextMenu() {
  return Story([{
    type: 'item',
    label: 'Share with',
    children: [{
      type: 'radiogroup',
      label: 'Share with',
      items: ['None', 'Product team', 'Organization', 'Company'],
      initialSelectedItem: 'Product team'
    }]
  }, {
    type: 'divider'
  }, {
    type: 'item',
    label: 'Cut',
    shortcut: '⌘X'
  }, {
    type: 'item',
    label: 'Copy',
    shortcut: '⌘C'
  }, {
    type: 'item',
    label: 'Copy path',
    shortcut: '⌥⌘C'
  }, {
    type: 'item',
    label: 'Paste',
    shortcut: '⌘V',
    disabled: true
  }, {
    type: 'item',
    label: 'Duplicate'
  }, {
    type: 'divider'
  }, {
    type: 'selectable',
    label: 'Publish',
    initialChecked: true
  }, {
    type: 'divider'
  }, {
    type: 'item',
    label: 'Rename',
    shortcut: '↩︎'
  }, {
    type: 'item',
    label: 'Delete',
    shortcut: '⌘⌫',
    kind: 'danger'
  }]);
};

exports._ContextMenu = _ContextMenu;
_ContextMenu.storyName = 'ContextMenu';

var _MultipleGroups = function _MultipleGroups() {
  return Story([{
    type: 'group',
    label: 'Font style',
    children: [{
      type: 'selectable',
      label: 'Bold'
    }, {
      type: 'selectable',
      label: 'Italic'
    }]
  }, {
    type: 'divider'
  }, {
    type: 'radiogroup',
    label: 'Text color',
    items: ['Black', 'Blue', 'Red', 'Green'],
    initialSelectedItem: 'Black'
  }, {
    type: 'divider'
  }, {
    type: 'radiogroup',
    label: 'Text decoration',
    items: ['None', 'Overline', 'Line-through', 'Underline'],
    initialSelectedItem: 'None'
  }]);
};

exports._MultipleGroups = _MultipleGroups;
_MultipleGroups.storyName = 'MultipleGroups';