"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = require("react");

/**
 * @param {Element|Document|Window} [trigger=document] The element which should trigger the Menu on right-click
 * @returns {object} Props object to pass onto Menu component
 */
function useContextMenu() {
  var trigger = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var _useState3 = (0, _react.useState)([0, 0]),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      position = _useState4[0],
      setPosition = _useState4[1];

  function openContextMenu(e) {
    e.preventDefault();
    var x = e.x,
        y = e.y;
    setPosition([x, y]);
    setOpen(true);
  }

  function onClose() {
    setOpen(false);
  }

  (0, _react.useEffect)(function () {
    if (trigger && trigger instanceof Element || trigger instanceof Document || trigger instanceof Window) {
      trigger.addEventListener('contextmenu', openContextMenu);
      return function () {
        trigger.removeEventListener('contextmenu', openContextMenu);
      };
    }
  }, [trigger]);
  return {
    open: open,
    x: position[0],
    y: position[1],
    onClose: onClose
  };
}

var _default = useContextMenu;
exports.default = _default;