"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _excluded = ["className", "children", "title", "description", "stickyHeader", "useStaticWidth"];
var prefix = _carbonComponents.settings.prefix;

var TableContainer = function TableContainer(_ref) {
  var _cx;

  var className = _ref.className,
      children = _ref.children,
      title = _ref.title,
      description = _ref.description,
      stickyHeader = _ref.stickyHeader,
      useStaticWidth = _ref.useStaticWidth,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var tableContainerClasses = (0, _classnames.default)(className, "".concat(prefix, "--data-table-container"), (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--max-width"), stickyHeader), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table-container--static"), useStaticWidth), _cx));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    className: tableContainerClasses
  }), title && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--data-table-header")
  }, /*#__PURE__*/_react.default.createElement("h4", {
    className: "".concat(prefix, "--data-table-header__title")
  }, title), /*#__PURE__*/_react.default.createElement("p", {
    className: "".concat(prefix, "--data-table-header__description")
  }, description)), children);
};

TableContainer.propTypes = {
  children: _propTypes.default.node,
  className: _propTypes.default.string,

  /**
   * Optional description text for the Table
   */
  description: _propTypes.default.node,

  /**
   * Specify whether the table should have a sticky header
   */
  stickyHeader: _propTypes.default.bool,

  /**
   * Provide a title for the Table
   */
  title: _propTypes.default.node,

  /**
   * If true, will use a width of 'fit-content' to match the inner table width
   */
  useStaticWidth: _propTypes.default.bool
};
var _default = TableContainer;
exports.default = _default;