"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _sorting = require("./state/sorting");

var _useId = require("../../internal/useId");

var _excluded = ["className", "children", "colSpan", "isSortable", "isSortHeader", "onClick", "scope", "sortDirection", "translateWithId", "id"];

var _sortDirections;

var prefix = _carbonComponents.settings.prefix;
var translationKeys = {
  buttonDescription: 'carbon.table.header.icon.description'
};

var translateWithId = function translateWithId(key, _ref) {
  var header = _ref.header,
      sortDirection = _ref.sortDirection,
      isSortHeader = _ref.isSortHeader,
      sortStates = _ref.sortStates;

  if (key === translationKeys.buttonDescription) {
    if (isSortHeader) {
      // When transitioning, we know that the sequence of states is as follows:
      // NONE -> ASC -> DESC -> NONE
      if (sortDirection === sortStates.NONE) {
        return "Click to sort rows by ".concat(header, " header in ascending order");
      }

      if (sortDirection === sortStates.ASC) {
        return "Click to sort rows by ".concat(header, " header in descending order");
      }

      return "Click to unsort rows by ".concat(header, " header");
    }

    return "Click to sort rows by ".concat(header, " header in ascending order");
  }

  return '';
};

var sortDirections = (_sortDirections = {}, (0, _defineProperty2.default)(_sortDirections, _sorting.sortStates.NONE, 'none'), (0, _defineProperty2.default)(_sortDirections, _sorting.sortStates.ASC, 'ascending'), (0, _defineProperty2.default)(_sortDirections, _sorting.sortStates.DESC, 'descending'), _sortDirections);

var TableHeader = /*#__PURE__*/_react.default.forwardRef(function TableHeader(_ref2, ref) {
  var _cx;

  var headerClassName = _ref2.className,
      children = _ref2.children,
      colSpan = _ref2.colSpan,
      isSortable = _ref2.isSortable,
      isSortHeader = _ref2.isSortHeader,
      onClick = _ref2.onClick,
      scope = _ref2.scope,
      sortDirection = _ref2.sortDirection,
      t = _ref2.translateWithId,
      id = _ref2.id,
      rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  var uniqueId = (0, _useId.useId)('table-sort');

  if (!isSortable) {
    return /*#__PURE__*/_react.default.createElement("th", (0, _extends2.default)({}, rest, {
      id: id,
      className: headerClassName,
      scope: scope,
      colSpan: colSpan,
      ref: ref
    }), children ? /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--table-header-label")
    }, children) : null);
  }

  var className = (0, _classnames.default)(headerClassName, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--table-sort"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--table-sort--active"), isSortHeader && sortDirection !== _sorting.sortStates.NONE), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--table-sort--ascending"), isSortHeader && sortDirection === _sorting.sortStates.DESC), _cx));
  var ariaSort = !isSortHeader ? 'none' : sortDirections[sortDirection];
  var sortDescription = t('carbon.table.header.icon.description', {
    header: children,
    sortDirection: sortDirection,
    isSortHeader: isSortHeader,
    sortStates: _sorting.sortStates
  });
  return /*#__PURE__*/_react.default.createElement("th", {
    id: id,
    "aria-sort": ariaSort,
    className: headerClassName,
    colSpan: colSpan,
    ref: ref,
    scope: scope
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'none'
    },
    id: uniqueId
  }, sortDescription), /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    type: "button",
    "aria-describedby": uniqueId,
    className: className,
    onClick: onClick
  }, rest), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--table-sort__flex")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--table-header-label")
  }, children), /*#__PURE__*/_react.default.createElement(_iconsReact.ArrowUp20, {
    className: "".concat(prefix, "--table-sort__icon")
  }), /*#__PURE__*/_react.default.createElement(_iconsReact.ArrowsVertical20, {
    className: "".concat(prefix, "--table-sort__icon-unsorted")
  }))));
});

TableHeader.propTypes = {
  /**
   * Pass in children that will be embedded in the table header label
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify `colSpan` as a non-negative integer value to indicate how
   * many columns the TableHeader cell extends in a table
   */
  colSpan: _propTypes.default.number,

  /**
   * Supply an id to the th element.
   */
  id: _propTypes.default.string,

  /**
   * Specify whether this header is the header by which a table is being sorted
   * by
   */
  isSortHeader: _propTypes.default.bool,

  /**
   * Specify whether this header is one through which a user can sort the table
   */
  isSortable: _propTypes.default.bool,

  /**
   * Hook that is invoked when the header is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the scope of this table header. You can find more info about this
   * attribute at the following URL:
   * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th#attr-scope
   */
  scope: _propTypes.default.string.isRequired,

  /**
   * Specify which direction we are currently sorting by, should be one of DESC,
   * NONE, or ASC.
   */
  sortDirection: _propTypes.default.oneOf(Object.values(_sorting.sortStates)),

  /**
   * Supply a method to translate internal strings with your i18n tool of
   * choice. Translation keys are available on the `translationKeys` field for
   * this component.
   */
  translateWithId: _propTypes.default.func
};
TableHeader.defaultProps = {
  isSortable: false,
  scope: 'col',
  translateWithId: translateWithId
};
TableHeader.translationKeys = Object.values(translationKeys);
TableHeader.displayName = 'TableHeader';
var _default = TableHeader;
exports.default = _default;