"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithSelectionAndSorting = exports.WithRadioSelection = exports.Usage = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _DataTable = _interopRequireWildcard(require("../../DataTable"));

var _shared = require("./shared");

var _DataTable2 = _interopRequireDefault(require("../DataTable.mdx"));

var _addonActions = require("@storybook/addon-actions");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/DataTable/Selection',
  component: _DataTable.default,
  subcomponents: {
    TableSelectAll: _DataTable.TableSelectAll,
    TableSelectRow: _DataTable.TableSelectRow,
    Table: _DataTable.Table,
    TableBody: _DataTable.TableBody,
    TableCell: _DataTable.TableCell,
    TableContainer: _DataTable.TableContainer,
    TableHead: _DataTable.TableHead,
    TableHeader: _DataTable.TableHeader,
    TableRow: _DataTable.TableRow
  },
  parameters: {
    docs: {
      page: _DataTable2.default
    }
  }
};
exports.default = _default;

var Usage = function Usage() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers
  }, function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getSelectionProps = _ref.getSelectionProps,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With selection"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
        key: i
      }, getRowProps({
        row: row
      }), {
        onClick: function onClick(evt) {
          (0, _addonActions.action)('TableRow onClick')(evt);
        }
      }), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectRow, (0, _extends2.default)({}, getSelectionProps({
        row: row
      }), {
        onSelect: function onSelect(evt) {
          (0, _addonActions.action)('TableSelectRow onSelect')(evt);
          getSelectionProps({
            row: row
          }).onSelect(evt);
        }
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};

exports.Usage = Usage;

var WithRadioSelection = function WithRadioSelection() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers,
    radio: true
  }, function (_ref2) {
    var rows = _ref2.rows,
        headers = _ref2.headers,
        getHeaderProps = _ref2.getHeaderProps,
        getRowProps = _ref2.getRowProps,
        getSelectionProps = _ref2.getSelectionProps,
        getTableProps = _ref2.getTableProps,
        getTableContainerProps = _ref2.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With radio selection"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement("th", {
      scope: "col"
    }), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
        key: i
      }, getRowProps({
        row: row
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectRow, getSelectionProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};

exports.WithRadioSelection = WithRadioSelection;

var WithSelectionAndSorting = function WithSelectionAndSorting() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers,
    isSortable: true
  }, function (_ref3) {
    var rows = _ref3.rows,
        headers = _ref3.headers,
        getHeaderProps = _ref3.getHeaderProps,
        getRowProps = _ref3.getRowProps,
        getSelectionProps = _ref3.getSelectionProps,
        getTableProps = _ref3.getTableProps,
        getTableContainerProps = _ref3.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With selection"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
        key: i
      }, getRowProps({
        row: row
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectRow, getSelectionProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};

exports.WithSelectionAndSorting = WithSelectionAndSorting;