"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _excluded = ["headers", "rowCount", "columnCount", "zebra", "compact", "className", "showHeader", "showToolbar"];
var prefix = _carbonComponents.settings.prefix;

var DataTableSkeleton = function DataTableSkeleton(_ref) {
  var _cx;

  var headers = _ref.headers,
      rowCount = _ref.rowCount,
      columnCount = _ref.columnCount,
      zebra = _ref.zebra,
      compact = _ref.compact,
      className = _ref.className,
      showHeader = _ref.showHeader,
      showToolbar = _ref.showToolbar,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var dataTableSkeletonClasses = (0, _classnames.default)(className, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--skeleton"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--zebra"), zebra), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--compact"), compact), _cx));
  var rowRepeat = rowCount;
  var rows = Array(rowRepeat);
  var columnsArray = Array.from({
    length: columnCount
  }, function (_, index) {
    return index;
  });

  for (var i = 0; i < rowRepeat; i++) {
    rows[i] = /*#__PURE__*/_react.default.createElement("tr", {
      key: i
    }, columnsArray.map(function (j) {
      return /*#__PURE__*/_react.default.createElement("td", {
        key: j
      }, /*#__PURE__*/_react.default.createElement("span", null));
    }));
  }

  return /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--skeleton ").concat(prefix, "--data-table-container")
  }, showHeader ? /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--data-table-header")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--data-table-header__title")
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--data-table-header__description")
  })) : null, showToolbar ? /*#__PURE__*/_react.default.createElement("section", {
    "aria-label": "data table toolbar",
    className: "".concat(prefix, "--table-toolbar")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--toolbar-content")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--skeleton ").concat(prefix, "--btn ").concat(prefix, "--btn--sm")
  }))) : null, /*#__PURE__*/_react.default.createElement("table", (0, _extends2.default)({
    className: dataTableSkeletonClasses
  }, rest), /*#__PURE__*/_react.default.createElement("thead", null, /*#__PURE__*/_react.default.createElement("tr", null, columnsArray.map(function (i) {
    var _headers$i;

    return /*#__PURE__*/_react.default.createElement("th", {
      key: i
    }, headers ? /*#__PURE__*/_react.default.createElement("div", {
      className: "bx--table-header-label"
    }, (_headers$i = headers[i]) === null || _headers$i === void 0 ? void 0 : _headers$i.header) : /*#__PURE__*/_react.default.createElement("span", null));
  }))), /*#__PURE__*/_react.default.createElement("tbody", null, rows)));
};

DataTableSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Specify the number of columns that you want to render in the skeleton state
   */
  columnCount: _propTypes.default.number,

  /**
   * Optionally specify whether you want the Skeleton to be rendered as a
   * compact DataTable
   */
  compact: _propTypes.default.bool,

  /**
   * Optionally specify the displayed headers
   */
  headers: _propTypes.default.oneOfType([_propTypes.default.array, _propTypes.default.shape({
    key: _propTypes.default.string
  })]),

  /**
   * Specify the number of rows that you want to render in the skeleton state
   */
  rowCount: _propTypes.default.number,

  /**
   * Specify if the table header should be rendered as part of the skeleton.
   */
  showHeader: _propTypes.default.bool,

  /**
   * Specify if the table toolbar should be rendered as part of the skeleton.
   */
  showToolbar: _propTypes.default.bool,

  /**
   * Optionally specify whether you want the DataTable to be zebra striped
   */
  zebra: _propTypes.default.bool
};
DataTableSkeleton.defaultProps = {
  rowCount: 5,
  columnCount: 5,
  zebra: false,
  compact: false,
  showHeader: true,
  showToolbar: true
};
var _default = DataTableSkeleton;
exports.default = _default;