"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _excluded = ["id", "labelText", "disabled", "invalid", "invalidText", "helperText", "hideLabel", "onChange", "onClick", "placeholder", "type", "datePickerType", "pattern", "iconDescription", "openCalendar", "size", "warn", "warnText"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;

var DatePickerInput = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(DatePickerInput, _Component);

  var _super = _createSuper(DatePickerInput);

  function DatePickerInput() {
    (0, _classCallCheck2.default)(this, DatePickerInput);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(DatePickerInput, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _classNames4,
          _this = this;

      var _this$props = this.props,
          id = _this$props.id,
          labelText = _this$props.labelText,
          disabled = _this$props.disabled,
          invalid = _this$props.invalid,
          invalidText = _this$props.invalidText,
          helperText = _this$props.helperText,
          hideLabel = _this$props.hideLabel,
          _onChange = _this$props.onChange,
          _onClick = _this$props.onClick,
          placeholder = _this$props.placeholder,
          type = _this$props.type,
          datePickerType = _this$props.datePickerType,
          pattern = _this$props.pattern,
          iconDescription = _this$props.iconDescription,
          openCalendar = _this$props.openCalendar,
          size = _this$props.size,
          warn = _this$props.warn,
          warnText = _this$props.warnText,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var datePickerInputProps = {
        id: id,
        onChange: function onChange(evt) {
          if (!disabled) {
            _onChange(evt);
          }
        },
        onClick: function onClick(evt) {
          if (!disabled) {
            _onClick(evt);
          }
        },
        placeholder: placeholder,
        type: type,
        pattern: pattern
      };
      var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--date-picker-input__wrapper"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--date-picker-input__wrapper--invalid"), invalid), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--date-picker-input__wrapper--warn"), warn), _classNames));
      var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--visually-hidden"), hideLabel), (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--label--disabled"), disabled), _classNames2));
      var helperTextClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), (0, _defineProperty2.default)({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
      var inputClasses = (0, _classnames.default)("".concat(prefix, "--date-picker__input"), (_classNames4 = {}, (0, _defineProperty2.default)(_classNames4, "".concat(prefix, "--date-picker__input--").concat(size), size), (0, _defineProperty2.default)(_classNames4, "".concat(prefix, "--date-picker__input--invalid"), invalid), _classNames4));

      var datePickerIcon = function () {
        if (datePickerType === 'simple' && !invalid && !warn) {
          return;
        }

        if (invalid) {
          return /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
            className: "".concat(prefix, "--date-picker__icon ").concat(prefix, "--date-picker__icon--invalid")
          });
        }

        if (!invalid && warn) {
          return /*#__PURE__*/_react.default.createElement(_iconsReact.WarningAltFilled16, {
            className: "".concat(prefix, "--date-picker__icon ").concat(prefix, "--date-picker__icon--warn")
          });
        }

        return /*#__PURE__*/_react.default.createElement(_iconsReact.Calendar16, {
          className: "".concat(prefix, "--date-picker__icon"),
          "aria-label": iconDescription,
          onClick: openCalendar,
          role: "img"
        }, iconDescription && /*#__PURE__*/_react.default.createElement("title", null, iconDescription));
      }();

      var label = labelText ? /*#__PURE__*/_react.default.createElement("label", {
        htmlFor: id,
        className: labelClasses
      }, labelText) : null;
      var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
        className: helperTextClasses
      }, helperText) : null;
      var error = null;

      if (invalid) {
        error = /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--form-requirement")
        }, invalidText);
      } else if (warn) {
        error = /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--form-requirement")
        }, warnText);
      }

      var containerClasses = (0, _classnames.default)("".concat(prefix, "--date-picker-container"), (0, _defineProperty2.default)({}, "".concat(prefix, "--date-picker--nolabel"), !label));
      var input = invalid ? /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, other, datePickerInputProps, {
        disabled: disabled,
        ref: function ref(input) {
          _this.input = input;
        },
        "data-invalid": true,
        className: inputClasses
      })) : /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
        ref: function ref(input) {
          _this.input = input;
        }
      }, other, datePickerInputProps, {
        disabled: disabled,
        className: inputClasses
      }));
      return /*#__PURE__*/_react.default.createElement("div", {
        className: containerClasses
      }, label, /*#__PURE__*/_react.default.createElement("div", {
        className: wrapperClasses
      }, input, datePickerIcon), error, helper);
    }
  }]);
  return DatePickerInput;
}(_react.Component);

exports.default = DatePickerInput;
(0, _defineProperty2.default)(DatePickerInput, "propTypes", {
  /**
   * The type of the date picker:
   *
   * * `simple` - Without calendar dropdown.
   * * `single` - With calendar dropdown and single date.
   * * `range` - With calendar dropdown and a date range.
   */
  datePickerType: _propTypes.default.oneOf(['simple', 'single', 'range']),

  /**
   * Specify whether or not the input should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: _propTypes.default.node,

  /**
   * Specify if the label should be hidden
   */
  hideLabel: _propTypes.default.bool,

  /**
   * The description of the calendar icon.
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify an id that uniquely identifies the `<input>`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify whether or not the input should be invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Specify the text to be rendered when the input is invalid
   */
  invalidText: _propTypes.default.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Specify an `onChange` handler that is called whenever a change in the
   * input field has occurred
   */
  onChange: _propTypes.default.func,

  /**
   * Provide a function to be called when the input field is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Provide a function to be called when the input field is clicked
   */
  openCalendar: _propTypes.default.func,

  /**
   * Provide a regular expression that the input value must match
   */
  pattern: function pattern(props, propName, componentName) {
    if (props[propName] === undefined) {
      return;
    }

    try {
      new RegExp(props[propName]);
    } catch (e) {
      return new Error("Invalid value of prop '".concat(propName, "' supplied to '").concat(componentName, "', it should be a valid regular expression"));
    }
  },

  /**
   * Specify the placeholder text
   */
  placeholder: _propTypes.default.string,

  /**
   * Specify the size of the Date Picker Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify the type of the `<input>`
   */
  type: _propTypes.default.string,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
});
(0, _defineProperty2.default)(DatePickerInput, "defaultProps", {
  pattern: '\\d{1,2}\\/\\d{1,2}\\/\\d{4}',
  type: 'text',
  disabled: false,
  invalid: false,
  onClick: function onClick() {},
  onChange: function onChange() {}
});