"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDisclosure = useDisclosure;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = require("react");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function useDisclosure(id) {
  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var buttonProps = {
    'aria-controls': id,
    'aria-expanded': open,
    onClick: function onClick() {
      setOpen(!open);
    }
  };
  var contentProps = {
    id: id
  };
  return {
    buttonProps: buttonProps,
    contentProps: contentProps,
    open: open
  };
}