"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Playground = exports.Inline = exports.RenderSelectedItem = exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Dropdown = _interopRequireDefault(require("../Dropdown"));

var _Dropdown2 = _interopRequireDefault(require("./Dropdown.Skeleton"));

var _Dropdown3 = _interopRequireDefault(require("./Dropdown.mdx"));

var _iconsReact = require("@carbon/icons-react");

var _excluded = ["listBoxMenuIconTranslationIds"];
var items = [{
  id: 'option-0',
  text: 'Lorem, ipsum dolor sit amet consectetur adipisicing elit.'
}, {
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'option-4',
  text: 'Option 4'
}, {
  id: 'option-5',
  text: 'Option 5'
}];
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var directions = {
  'Bottom (default)': 'bottom',
  'Top ': 'top'
};
var types = {
  Default: 'default',
  Inline: 'inline'
};

var props = function props() {
  return {
    id: (0, _addonKnobs.text)('Dropdown ID (id)', 'carbon-dropdown-example'),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
    direction: (0, _addonKnobs.select)('Dropdown direction (direction)', directions, 'bottom'),
    label: (0, _addonKnobs.text)('Label (label)', 'Dropdown menu options'),
    ariaLabel: (0, _addonKnobs.text)('Aria Label (ariaLabel)', 'Dropdown'),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    titleText: (0, _addonKnobs.text)('Title (titleText)', 'Dropdown label'),
    hideLabel: (0, _addonKnobs.boolean)('No title text shown (hideLabel)', false),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'This is some helper text.'),
    invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid)', false),
    invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText)', 'A valid value is required'),
    type: (0, _addonKnobs.select)('Type (type)', types, 'default'),
    warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
    warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'This mode may perform worse on older machines'),
    listBoxMenuIconTranslationIds: (0, _addonKnobs.object)('Listbox menu icon translation IDs (for translateWithId callback)', {
      'close.menu': 'Close menu',
      'open.menu': 'Open menu'
    })
  };
};

var _default = {
  title: 'Components/Dropdown',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Dropdown.default,
    subcomponents: {
      DropdownSkeleton: _Dropdown2.default
    },
    docs: {
      page: _Dropdown3.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
    id: "default",
    titleText: "Dropdown label",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    onChange: (0, _addonActions.action)('onChange')
  }));
};

exports.Default = Default;

var RenderSelectedItem = function RenderSelectedItem() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
    id: "default",
    titleText: "Dropdown label",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: [{
      id: 'option-0',
      icon: _iconsReact.ChartColumnFloating16,
      text: 'Column Chart'
    }, {
      id: 'option-1',
      icon: _iconsReact.ChartBubble16,
      text: 'Bubble Chart'
    }, {
      id: 'option-2',
      icon: _iconsReact.ChartVennDiagram16,
      text: 'Venn Diagram'
    }],
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    itemToElement: function itemToElement(item) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(item.icon), /*#__PURE__*/_react.default.createElement("span", {
        style: {
          paddingLeft: '1rem',
          paddingBottom: '1rem'
        }
      }, item.text));
    },
    renderSelectedItem: function renderSelectedItem(item) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(item.icon), /*#__PURE__*/_react.default.createElement("span", {
        style: {
          paddingLeft: '1rem',
          paddingBottom: '1rem'
        }
      }, item.text));
    },
    onChange: (0, _addonActions.action)('onChange')
  }));
};

exports.RenderSelectedItem = RenderSelectedItem;

var Inline = function Inline() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 600
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
    id: "inline",
    titleText: "Inline dropdown label",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    onChange: (0, _addonActions.action)('onChange')
  }));
};

exports.Inline = Inline;

var Playground = function Playground() {
  var _props = props(),
      listBoxMenuIconTranslationIds = _props.listBoxMenuIconTranslationIds,
      dropdownProps = (0, _objectWithoutProperties2.default)(_props, _excluded);

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown.default, (0, _extends2.default)({}, dropdownProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    }
  })));
};

exports.Playground = Playground;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown2.default, null));
};

exports.Skeleton = Skeleton;