"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _ListBox = require("../ListBox");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "size", "inline"];

var DropdownSkeleton = function DropdownSkeleton(_ref) {
  var _cx;

  var className = _ref.className,
      size = _ref.size,
      inline = _ref.inline,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var wrapperClasses = (0, _classnames.default)(className, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--skeleton"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--dropdown-v2"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--form-item"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--").concat(size), size), _cx));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: wrapperClasses
  }, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--list-box__field")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--list-box__label")
  })));
};

DropdownSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Specify whether you want the inline version of this control
   */
  inline: (0, _deprecate.default)(_propTypes.default.bool, "The `inline` prop has been deprecated and will\n    be removed in the next major release. To specify the inline variant of Dropdown, please use the `type` prop."),

  /**
   * Specify the size of the ListBox.
   */
  size: _ListBox.PropTypes.ListBoxSize
};
var _default = DropdownSkeleton;
exports.default = _default;