"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.InlineWithLayer = exports.withLayer = exports.Inline = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ = _interopRequireWildcard(require("../"));

var _Layer = require("../../Layer");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var items = [{
  id: 'option-0',
  text: 'Lorem, ipsum dolor sit amet consectetur adipisicing elit.'
}, {
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'option-4',
  text: 'Option 4'
}, {
  id: 'option-5',
  text: 'Option 5'
}];
var _default = {
  title: 'Components/Dropdown',
  parameters: {
    component: _.default,
    subcomponents: {
      DropdownSkeleton: _.DropdownSkeleton
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "default",
    titleText: "Dropdown label",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }));
};

exports.Default = Default;

var Inline = function Inline() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 600
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "inline",
    titleText: "Inline dropdown label",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }));
};

exports.Inline = Inline;

var withLayer = function withLayer() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "default",
    titleText: "First Layer",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "default",
    titleText: "Second Layer",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "default",
    titleText: "Third Layer",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }))));
};

exports.withLayer = withLayer;

var InlineWithLayer = function InlineWithLayer() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 600
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "inline",
    titleText: "First Layer",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "inline",
    titleText: "Second Layer",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "inline",
    titleText: "Third Layer",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }))));
};

exports.InlineWithLayer = InlineWithLayer;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_.DropdownSkeleton, null));
};

exports.Skeleton = Skeleton;