"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureFlags = FeatureFlags;
exports.useFeatureFlags = useFeatureFlags;
exports.useFeatureFlag = useFeatureFlag;
exports.FeatureFlagContext = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _featureFlags = require("@carbon/feature-flags");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2015, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * Our FeatureFlagContext is used alongside the FeatureFlags component to enable
 * or disable feature flags in a given React tree
 */
var FeatureFlagContext = /*#__PURE__*/(0, _react.createContext)(_featureFlags.FeatureFlags);
/**
 * Supports an object of feature flag values with the `flags` prop, merging them
 * along with the current `FeatureFlagContext` to provide consumers to check if
 * a feature flag is enabled or disabled in a given React tree
 */

exports.FeatureFlagContext = FeatureFlagContext;

function FeatureFlags(_ref) {
  var children = _ref.children,
      _ref$flags = _ref.flags,
      flags = _ref$flags === void 0 ? {} : _ref$flags;
  var parentScope = (0, _react.useContext)(FeatureFlagContext);

  var _useState = (0, _react.useState)(parentScope),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      prevParentScope = _useState2[0],
      setPrevParentScope = _useState2[1];

  var _useState3 = (0, _react.useState)(function () {
    var scope = (0, _featureFlags.createScope)(flags);
    scope.mergeWithScope(parentScope);
    return scope;
  }),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      scope = _useState4[0],
      updateScope = _useState4[1];

  if (parentScope !== prevParentScope) {
    var _scope = (0, _featureFlags.createScope)(flags);

    _scope.mergeWithScope(parentScope);

    updateScope(_scope);
    setPrevParentScope(parentScope);
  } // We use a custom hook to detect if any of the keys or their values change
  // for flags that are passed in. If they have changed, then we re-create the
  // FeatureFlagScope using the new flags


  useChangedValue(flags, isEqual, function (changedFlags) {
    var scope = (0, _featureFlags.createScope)(changedFlags);
    scope.mergeWithScope(parentScope);
    updateScope(scope);
  });
  return /*#__PURE__*/_react.default.createElement(FeatureFlagContext.Provider, {
    value: scope
  }, children);
}

FeatureFlags.propTypes = {
  children: _propTypes.default.node,

  /**
   * Provide the feature flags to enabled or disabled in the current React tree
   */
  flags: _propTypes.default.objectOf(_propTypes.default.bool)
};
/**
 * This hook will store previous versions of the given `value` and compare the
 * current value to the previous one using the `compare` function. If the
 * compare function returns true, then the given `callback` is invoked in an
 * effect.
 *
 * @param {any} value
 * @param {Function} compare
 * @param {Function} callback
 */

function useChangedValue(value, compare, callback) {
  var initialRender = (0, _react.useRef)(false);
  var savedCallback = (0, _react.useRef)(callback);

  var _useState5 = (0, _react.useState)(value),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      prevValue = _useState6[0],
      setPrevValue = _useState6[1];

  if (!compare(prevValue, value)) {
    setPrevValue(value);
  }

  (0, _react.useEffect)(function () {
    savedCallback.current = callback;
  });
  (0, _react.useEffect)(function () {
    // We only want the callback triggered after the first render
    if (initialRender.current) {
      savedCallback.current(prevValue);
    }
  }, [prevValue]);
  (0, _react.useEffect)(function () {
    initialRender.current = true;
  }, []);
}
/**
 * Access whether a given flag is enabled or disabled in a given
 * FeatureFlagContext
 *
 * @returns {boolean}
 */


function useFeatureFlag(flag) {
  var scope = (0, _react.useContext)(FeatureFlagContext);
  return scope.enabled(flag);
}
/**
 * Access all feature flag information for the given FeatureFlagContext
 *
 * @returns {FeatureFlagScope}
 */


function useFeatureFlags() {
  return (0, _react.useContext)(FeatureFlagContext);
}
/**
 * Compare two objects and determine if they are equal. This is a shallow
 * comparison since the objects we are comparing are objects with boolean flags
 * from the flags prop in the `FeatureFlags` component
 *
 * @param {object} a
 * @param {object} b
 * @returns {boolean}
 */


function isEqual(a, b) {
  if (a === b) {
    return true;
  }

  for (var _i = 0, _Object$keys = Object.keys(a); _i < _Object$keys.length; _i++) {
    var key = _Object$keys[_i];

    if (a[key] !== b[key]) {
      return false;
    }
  }

  for (var _i2 = 0, _Object$keys2 = Object.keys(b); _i2 < _Object$keys2.length; _i2++) {
    var _key = _Object$keys2[_i2];

    if (b[_key] !== a[_key]) {
      return false;
    }
  }

  return true;
}