"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _Filename = _interopRequireDefault(require("./Filename"));

var _keyboard = require("../../internal/keyboard");

var _uniqueId = _interopRequireDefault(require("../../tools/uniqueId"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["uuid", "name", "status", "iconDescription", "onDelete", "invalid", "errorSubject", "errorBody", "size"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function FileUploaderItem(_ref) {
  var _cx;

  var uuid = _ref.uuid,
      name = _ref.name,
      status = _ref.status,
      iconDescription = _ref.iconDescription,
      onDelete = _ref.onDelete,
      invalid = _ref.invalid,
      errorSubject = _ref.errorSubject,
      errorBody = _ref.errorBody,
      size = _ref.size,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();

  var _useRef = (0, _react.useRef)(uuid || (0, _uniqueId.default)()),
      id = _useRef.current;

  var classes = (0, _classnames.default)("".concat(prefix, "--file__selected-file"), (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--file__selected-file--invalid"), invalid), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--file__selected-file--md"), size === 'field' || size === 'md'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--file__selected-file--sm"), size === 'small' || size === 'sm'), _cx));
  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
    className: classes
  }, other), /*#__PURE__*/_react.default.createElement("p", {
    className: "".concat(prefix, "--file-filename"),
    title: name
  }, name), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--file__state-container")
  }, /*#__PURE__*/_react.default.createElement(_Filename.default, {
    iconDescription: iconDescription,
    status: status,
    invalid: invalid,
    onKeyDown: function onKeyDown(evt) {
      if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
        if (status === 'edit') {
          onDelete(evt, {
            uuid: id
          });
        }
      }
    },
    onClick: function onClick(evt) {
      if (status === 'edit') {
        onDelete(evt, {
          uuid: id
        });
      }
    }
  })), invalid && errorSubject && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form-requirement")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form-requirement__title")
  }, errorSubject), errorBody && /*#__PURE__*/_react.default.createElement("p", {
    className: "".concat(prefix, "--form-requirement__supplement")
  }, errorBody)));
}

FileUploaderItem.propTypes = {
  /**
   * Error message body for an invalid file upload
   */
  errorBody: _propTypes.default.string,

  /**
   * Error message subject for an invalid file upload
   */
  errorSubject: _propTypes.default.string,

  /**
   * Description of status icon (displayed in native tooltip)
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify if the currently uploaded file is invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Name of the uploaded file
   */
  name: _propTypes.default.string,

  /**
   * Event handler that is called after removing a file from the file uploader
   * The event handler signature looks like `onDelete(evt, { uuid })`
   */
  onDelete: _propTypes.default.func,

  /**
   * Specify the size of the uploaded items, from a list of available
   * sizes. For `default` buttons, this prop can remain unspecified.
   * V11: `default`, `field`, and `small` will be removed
   */
  size: _propTypes.default.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg']),

  /**
   * Status of the file upload
   */
  status: _propTypes.default.oneOf(['uploading', 'edit', 'complete']),

  /**
   * Unique identifier for the file object
   */
  uuid: _propTypes.default.string
};
FileUploaderItem.defaultProps = {
  status: 'uploading',
  onDelete: function onDelete() {}
};
var _default = FileUploaderItem;
exports.default = _default;