"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FocusScope = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _useMergedRefs = require("../../internal/useMergedRefs");

var _useAutoFocus = require("./useAutoFocus");

var _useFocusScope = require("./useFocusScope");

var _useRestoreFocus = require("./useRestoreFocus");

var _excluded = ["as", "children", "initialFocusRef"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var FocusScope = /*#__PURE__*/React.forwardRef(function FocusScope(props, forwardRef) {
  var _props$as = props.as,
      BaseComponent = _props$as === void 0 ? 'div' : _props$as,
      children = props.children,
      initialFocusRef = props.initialFocusRef,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var containerRef = React.useRef(null);
  var focusScope = (0, _useFocusScope.useFocusScope)(containerRef);
  var ref = (0, _useMergedRefs.useMergedRefs)([forwardRef, containerRef]);
  (0, _useRestoreFocus.useRestoreFocus)(containerRef);
  (0, _useAutoFocus.useAutoFocus)(function () {
    if (initialFocusRef) {
      return initialFocusRef;
    }

    return focusScope.current.getFirstDescendant();
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FocusScopeBumper, {
    onFocus: function onFocus() {
      focusScope.current.focusLastDescendant();
    }
  }), /*#__PURE__*/React.createElement(BaseComponent, (0, _extends2.default)({}, rest, {
    ref: ref
  }), children), /*#__PURE__*/React.createElement(FocusScopeBumper, {
    onFocus: function onFocus() {
      focusScope.current.focusFirstDescendant();
    }
  }));
});
exports.FocusScope = FocusScope;

if (process.env.NODE_ENV !== "production") {
  FocusScope.displayName = 'FocusScope';
}

FocusScope.propTypes = {
  /**
   * Provide a custom element type for the containing element
   */
  as: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide the children to be rendered inside of the `FocusScope`
   */
  children: _propTypes.default.node,

  /**
   * Provide a `ref` that is used to place focus when the `FocusScope` is
   * initially opened
   */
  initialFocusRef: _propTypes.default.shape({
    current: _propTypes.default.any
  })
};
var bumperStyle = {
  outline: 'none',
  opacity: '0',
  position: 'fixed',
  pointerEvents: 'none'
};

function FocusScopeBumper(props) {
  return /*#__PURE__*/React.createElement("span", (0, _extends2.default)({
    "data-carbon-focus-scope": "",
    style: bumperStyle // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: "0"
  }, props));
}