"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRestoreFocus = useRestoreFocus;

var _react = require("react");

var _focus = require("../../internal/focus");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function useRestoreFocus(container) {
  var containsFocus = (0, _react.useRef)(false);
  (0, _react.useEffect)(function () {
    var initialActiveElement = document.activeElement;

    if (container.current && container.current.contains) {
      containsFocus.current = container.current.contains(document.activeElement);
    }

    function onFocusIn() {
      containsFocus.current = true;
    }

    function onFocusOut(event) {
      if (container.current && container.current.contains) {
        containsFocus.current = container.current.contains(event.relatedTarget);
      }
    }

    var element = container.current;
    element.addEventListener('focusin', onFocusIn);
    element.addEventListener('focusout', onFocusOut);
    return function () {
      element.removeEventListener('focusin', onFocusIn);
      element.removeEventListener('focusout', onFocusOut);

      if (containsFocus.current === true) {
        setTimeout(function () {
          (0, _focus.focus)(initialActiveElement);
        }, 0);
      }
    };
  }, [container]);
}