"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "children"];

var Form = function Form(_ref) {
  var className = _ref.className,
      children = _ref.children,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var classNames = (0, _classnames.default)("".concat(prefix, "--form"), className);
  return /*#__PURE__*/_react.default.createElement("form", (0, _extends2.default)({
    className: classNames
  }, other), ' ', children, ' ');
};

Form.propTypes = {
  /**
   * Provide children to be rendered inside of the <form> element
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom className to be applied on the containing <form> node
   */
  className: _propTypes.default.string
};
var _default = Form;
exports.default = _default;