"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["legendId", "legendText", "invalid", "children", "className", "message", "messageText", "hasMargin"];

var FormGroup = function FormGroup(_ref) {
  var legendId = _ref.legendId,
      legendText = _ref.legendText,
      invalid = _ref.invalid,
      children = _ref.children,
      className = _ref.className,
      message = _ref.message,
      messageText = _ref.messageText,
      hasMargin = _ref.hasMargin,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var classNamesLegend = (0, _classnames2.default)("".concat(prefix, "--label"), [enabled ? null : className]); // TODO - remove `fieldset--no-margin` in v11

  var classNamesFieldset = (0, _classnames2.default)("".concat(prefix, "--fieldset"), className, (0, _defineProperty2.default)({}, "".concat(prefix, "--fieldset--no-margin"), !hasMargin));
  return /*#__PURE__*/_react.default.createElement("fieldset", (0, _extends2.default)({}, invalid && {
    'data-invalid': ''
  }, {
    className: classNamesFieldset
  }, other, {
    "aria-labelledby": other['aria-labelledby'] || legendId
  }), /*#__PURE__*/_react.default.createElement("legend", {
    className: classNamesLegend,
    id: legendId || other['aria-labelledby']
  }, legendText), children, message ? /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form__requirements")
  }, messageText) : null);
};

FormGroup.propTypes = {
  /**
   * Provide the children form elements to be rendered inside of the <fieldset>
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom className to be applied to the containing <fieldset> node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether or not the FormGroup should provide bottom margin
   */
  hasMargin: _propTypes.default.bool,

  /**
   * Specify whether the <FormGroup> is invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Provide id for the fieldset <legend> which corresponds to the fieldset
   * `aria-labelledby`
   */
  legendId: _propTypes.default.node,

  /**
   * Provide the text to be rendered inside of the fieldset <legend>
   */
  legendText: _propTypes.default.node.isRequired,

  /**
   * Specify whether the message should be displayed in the <FormGroup>
   */
  message: _propTypes.default.bool,

  /**
   * Provide the text for the message in the <FormGroup>
   */
  messageText: _propTypes.default.string
};
FormGroup.defaultProps = {
  invalid: false,
  message: false,
  messageText: '',
  hasMargin: true
};
var _default = FormGroup;
exports.default = _default;