"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _excluded = ["className", "children"];
var prefix = _carbonComponents.settings.prefix;

var FormItem = function FormItem(_ref) {
  var className = _ref.className,
      children = _ref.children,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classNames = (0, _classnames.default)("".concat(prefix, "--form-item"), className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classNames
  }, other), children);
};

FormItem.propTypes = {
  /**
   * Provide content to be rendered in the form item
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom className to be applied to the containing node
   */
  className: _propTypes.default.string
};
var _default = FormItem;
exports.default = _default;