"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconButton = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Button = _interopRequireDefault(require("../Button"));

var _next = require("../Tooltip/next");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["align", "children", "defaultOpen", "enterDelayMs", "kind", "label", "leaveDelayMs"];

var IconButton = /*#__PURE__*/_react.default.forwardRef(function IconButton(props, ref) {
  var align = props.align,
      children = props.children,
      _props$defaultOpen = props.defaultOpen,
      defaultOpen = _props$defaultOpen === void 0 ? false : _props$defaultOpen,
      enterDelayMs = props.enterDelayMs,
      kind = props.kind,
      label = props.label,
      leaveDelayMs = props.leaveDelayMs,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement(_next.Tooltip, {
    align: align,
    className: "".concat(prefix, "--icon-tooltip"),
    defaultOpen: defaultOpen,
    enterDelayMs: enterDelayMs,
    label: label,
    leaveDelayMs: leaveDelayMs
  }, /*#__PURE__*/_react.default.createElement(_Button.default, (0, _extends2.default)({}, rest, {
    hasIconOnly: true,
    kind: kind,
    ref: ref,
    size: "sm"
  }), children));
});

exports.IconButton = IconButton;
IconButton.propTypes = {
  /**
   * Specify how the trigger should align with the tooltip
   */
  align: _propTypes.default.oneOf(['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'right']),

  /**
   * Provide an icon or asset to be rendered inside of the IconButton
   */
  children: _propTypes.default.node,

  /**
   * Specify whether the tooltip should be open when it first renders
   */
  defaultOpen: _propTypes.default.bool,

  /**
   * Specify the duration in milliseconds to delay before displaying the tooltip
   */
  enterDelayMs: _propTypes.default.number,

  /**
   * Specify the type of button to be used as the base for the IconButton
   */
  kind: _propTypes.default.oneOf(['primary', 'secondary', 'ghost', 'tertiary']),

  /**
   * Provide the label to be rendered inside of the Tooltip. The label will use
   * `aria-labelledby` and will fully describe the child node that is provided.
   * This means that if you have text in the child node it will not be
   * announced to the screen reader.
   */
  label: _propTypes.default.node.isRequired,

  /**
   * Specify the duration in milliseconds to delay before hiding the tooltip
   */
  leaveDelayMs: _propTypes.default.number
};