"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@testing-library/react");

var _InlineCheckbox = _interopRequireDefault(require("../InlineCheckbox"));

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('InlineCheckbox', function () {
  it('should render', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_InlineCheckbox.default, null));
    expect(_react2.screen.getByRole('checkbox')).toBeInTheDocument();
  });
  it('should only propagate click events from the input', function () {
    var onClick = jest.fn();
    (0, _react2.render)(
    /*#__PURE__*/

    /* eslint-disable jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions */
    _react.default.createElement("div", {
      onClick: onClick
    }, /*#__PURE__*/_react.default.createElement(_InlineCheckbox.default, null)));

    _userEvent.default.click(_react2.screen.getByRole('checkbox'));

    expect(onClick).toHaveBeenCalledTimes(1);
  });
});