"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UxExample = exports._InlineLoading = exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _Button = _interopRequireDefault(require("../../Button"));

var _ = _interopRequireDefault(require("../"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/InlineLoading',
  parameters: {
    component: _.default
  }
};
exports.default = _default;

var _InlineLoading = function _InlineLoading() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    status: "active",
    iconDescription: "Active loading indicator",
    description: "Loading data..."
  });
};

exports._InlineLoading = _InlineLoading;

var UxExample = function UxExample() {
  function MockSubmission(_ref) {
    var children = _ref.children;

    var _useState = (0, _react.useState)(false),
        _useState2 = (0, _slicedToArray2.default)(_useState, 2),
        isSubmitting = _useState2[0],
        setIsSubmitting = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
        success = _useState4[0],
        setSuccess = _useState4[1];

    var _useState5 = (0, _react.useState)('Submitting...'),
        _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
        description = _useState6[0],
        setDescription = _useState6[1];

    var _useState7 = (0, _react.useState)('off'),
        _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
        ariaLive = _useState8[0],
        setAriaLive = _useState8[1];

    var handleSubmit = function handleSubmit() {
      setIsSubmitting(true);
      setAriaLive('assertive'); // Instead of making a real request, we mock it with a timer

      setTimeout(function () {
        setIsSubmitting(false);
        setSuccess(true);
        setDescription('Submitted!'); // To make submittable again, we reset the state after a bit so the user gets completion feedback

        setTimeout(function () {
          setSuccess(false);
          setDescription('Submitting...');
          setAriaLive('off');
        }, 1500);
      }, 2000);
    };

    return children({
      handleSubmit: handleSubmit,
      isSubmitting: isSubmitting,
      success: success,
      description: description,
      ariaLive: ariaLive
    });
  }

  return /*#__PURE__*/_react.default.createElement(MockSubmission, null, function (_ref2) {
    var handleSubmit = _ref2.handleSubmit,
        isSubmitting = _ref2.isSubmitting,
        success = _ref2.success,
        description = _ref2.description,
        ariaLive = _ref2.ariaLive;
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: 'flex',
        width: '300px'
      }
    }, /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "secondary",
      disabled: isSubmitting || success
    }, "Cancel"), isSubmitting || success ? /*#__PURE__*/_react.default.createElement(_.default, {
      style: {
        marginLeft: '1rem'
      },
      description: description,
      status: success ? 'finished' : 'active',
      "aria-live": ariaLive
    }) : /*#__PURE__*/_react.default.createElement(_Button.default, {
      onClick: handleSubmit
    }, "Submit"));
  });
};

exports.UxExample = UxExample;