"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.translationIds = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _excluded = ["children", "disabled", "tabIndex"];
var prefix = _carbonComponents.settings.prefix; // No longer used, left export for backward-compatibility

var translationIds = {};
/**
 * `ListBoxField` is responsible for creating the containing node for valid
 * elements inside of a field. It also provides a11y-related attributes like
 * `role` to make sure a user can focus the given field.
 */

exports.translationIds = translationIds;

function ListBoxField(_ref) {
  var children = _ref.children,
      disabled = _ref.disabled,
      tabIndex = _ref.tabIndex,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: "".concat(prefix, "--list-box__field"),
    tabIndex: !disabled && tabIndex || -1
  }, rest), children);
}

ListBoxField.propTypes = {
  /**
   * Typically set by `getToggleButtonProps`, this should specify whether the
   * field has a popup.
   */
  'aria-haspopup': _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),

  /**
   * Provide the contents of your ListBoxField
   */
  children: _propTypes.default.node,

  /**
   * Specify if the parent <ListBox> is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * The role for the component, should be set by `getToggleButtonProps` coming
   * from Downshift
   */
  role: _propTypes.default.string,

  /**
   * Optional prop to specify the tabIndex of the <ListBox> trigger button
   */
  tabIndex: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
};
var _default = ListBoxField;
exports.default = _default;