"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _Loading = _interopRequireDefault(require("../Loading"));

var _Loading2 = _interopRequireDefault(require("./Loading.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var props = function props() {
  return {
    active: (0, _addonKnobs.boolean)('Active (active)', true),
    withOverlay: (0, _addonKnobs.boolean)('With overlay (withOverlay)', false),
    small: (0, _addonKnobs.boolean)('Small (small)', false),
    description: (0, _addonKnobs.text)('Description (description)', 'Active loading indicator')
  };
};

var _default = {
  title: 'Components/Loading',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Loading.default,
    docs: {
      page: _Loading2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_Loading.default, (0, _extends2.default)({}, props(), {
    className: 'some-class'
  }));
};

exports.Default = Default;
Default.parameters = {
  info: {
    text: "\n        Loading spinners are used when retrieving data or performing slow computations,\n        and help to notify users that loading is underway. The 'active' property is true by default;\n        set to false to end the animation.\n      "
  }
};