"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _react = _interopRequireDefault(require("react"));

var _Loading = _interopRequireDefault(require("../Loading"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

var _react2 = require("@carbon/test-utils/react");

var _jestCircus = require("jest-circus");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
describe('Loading', function () {
  (0, _jestCircus.afterEach)(_react2.cleanup);
  describe('automated accessibility testing', function () {
    it('should have no Axe violations', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
      var _render, container;

      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _render = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Loading.default, null)), container = _render.container;
              _context.next = 3;
              return expect(container).toHaveNoAxeViolations();

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
    it('should have no AC violations', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
      var _render2, container;

      return _regenerator.default.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _render2 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Loading.default, null)), container = _render2.container;
              _context2.next = 3;
              return expect(container).toHaveNoACViolations('Loading');

            case 3:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));
  });
  describe('with a screenreader', function () {
    (0, _jestCircus.afterEach)(_react2.cleanup); // https://www.w3.org/TR/WCAG21/#headings-and-labels

    it('should have a label on the live region', function () {
      var _render3 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Loading.default, null)),
          container = _render3.container;

      var liveRegion = container.querySelector('[aria-live]');
      expect(liveRegion).toBeInstanceOf(HTMLElement);
      var id = liveRegion.getAttribute('aria-labelledby');
      expect(id).toBeDefined();
      var label = document.getElementById(id);
      expect(label).toBeDefined();
      expect((0, _typeof2.default)(label.textContent)).toBe('string');
    }); // https://www.w3.org/TR/WCAG21/#status-messages

    it('should announce a loading status', function () {
      var _render4 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Loading.default, null)),
          container = _render4.container;

      var liveRegion = container.querySelector('[aria-live]');
      expect(liveRegion).toBeInstanceOf(HTMLElement);
      var atomicBoolean = liveRegion.getAttribute('aria-atomic');
      expect(atomicBoolean).toBe('true');
      var ariaLiveValue = liveRegion.getAttribute('aria-live');
      expect(ariaLiveValue).toEqual('assertive');
    });
  });
  describe('renders as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Loading.default, {
      className: "extra-class"
    }));
    var overlay = wrapper.find(".".concat(prefix, "--loading-overlay"));
    var loader = wrapper.find(".".concat(prefix, "--loading"));
    var svg = loader.find('svg');
    it('should render with an overlay', function () {
      expect(overlay.length).toEqual(1);
    });
    it('should render with a loader', function () {
      expect(loader.length).toEqual(1);
    });
    it('should render an svg', function () {
      expect(svg.length).toEqual(1);
    });
    it('overlay has the expected class', function () {
      expect(overlay.hasClass("".concat(prefix, "--loading-overlay"))).toEqual(true);
    });
    it('loader has the expected classes', function () {
      expect(loader.hasClass("".concat(prefix, "--loading"))).toEqual(true);
    });
    it('svg has the correct class', function () {
      expect(svg.hasClass("".concat(prefix, "--loading__svg"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(loader.hasClass('extra-class')).toEqual(true);
    });
  });
  describe('sets props and state as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Loading.default, {
      className: "extra-class"
    }));
    it("should remove and add ".concat(prefix, "--loading--stop class"), function () {
      wrapper.setProps({
        active: false
      });
      expect(wrapper.find(".".concat(prefix, "--loading")).hasClass("".concat(prefix, "--loading--stop"))).toEqual(true);
      wrapper.setProps({
        active: true
      });
      expect(wrapper.find(".".concat(prefix, "--loading")).hasClass("".concat(prefix, "--loading--stop"))).toEqual(false);
    });
    it('should not render overlay when withOverlay is set to false', function () {
      wrapper.setProps({
        withOverlay: false
      });
      var overlay = wrapper.find(".".concat(prefix, "--loading-overlay"));
      expect(overlay.length).toEqual(0);
    });
  });
});