"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames3 = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _keyboard = require("../../internal/keyboard");

var _utils = require("./_utils");

var _Menu = _interopRequireDefault(require("./Menu"));

var _excluded = ["children", "disabled", "indented", "kind", "label", "level", "onClick", "renderIcon", "shortcut"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;
var hoverIntentDelay = 150; // in ms

function MenuOptionContent(_ref) {
  var label = _ref.label,
      info = _ref.info,
      disabled = _ref.disabled,
      Icon = _ref.icon,
      indented = _ref.indented;
  var classes = (0, _classnames3.default)("".concat(prefix, "--menu-option__content"), (0, _defineProperty2.default)({}, "".concat(prefix, "--menu-option__content--disabled"), disabled));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: classes
  }, indented && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--menu-option__icon")
  }, Icon && /*#__PURE__*/_react.default.createElement(Icon, null)), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--menu-option__label"),
    title: label
  }, label), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--menu-option__info")
  }, info));
}

function MenuOption(_ref2) {
  var _classnames2;

  var children = _ref2.children,
      disabled = _ref2.disabled,
      indented = _ref2.indented,
      _ref2$kind = _ref2.kind,
      kind = _ref2$kind === void 0 ? 'default' : _ref2$kind,
      label = _ref2.label,
      level = _ref2.level,
      _ref2$onClick = _ref2.onClick,
      onClick = _ref2$onClick === void 0 ? function () {} : _ref2$onClick,
      renderIcon = _ref2.renderIcon,
      shortcut = _ref2.shortcut,
      rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      submenuOpen = _useState2[0],
      setSubmenuOpen = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      submenuOpenedByKeyboard = _useState4[0],
      setSubmenuOpenedByKeyboard = _useState4[1];

  var rootRef = (0, _react.useRef)(null);
  var hoverIntentTimeout = (0, _react.useRef)(null);

  var subOptions = _react.default.Children.map(children, function (node) {
    if ( /*#__PURE__*/_react.default.isValidElement(node)) {
      return /*#__PURE__*/_react.default.cloneElement(node);
    }
  });

  function openSubmenu() {
    var openedByKeyboard = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    setSubmenuOpenedByKeyboard(openedByKeyboard);
    setSubmenuOpen(true);
  }

  function handleKeyDown(event) {
    if ((0, _utils.clickedElementHasSubnodes)(event) && ((0, _keyboard.match)(event, _keyboard.keys.ArrowRight) || (0, _keyboard.match)(event, _keyboard.keys.Enter) || (0, _keyboard.match)(event, _keyboard.keys.Space))) {
      openSubmenu(true);
    } else if (((0, _keyboard.match)(event, _keyboard.keys.Enter) || (0, _keyboard.match)(event, _keyboard.keys.Space)) && onClick) {
      onClick(event);
    }
  }

  function handleMouseEnter() {
    hoverIntentTimeout.current = setTimeout(openSubmenu, hoverIntentDelay);
  }

  function handleMouseLeave() {
    clearTimeout(hoverIntentTimeout === null || hoverIntentTimeout === void 0 ? void 0 : hoverIntentTimeout.current);
    setSubmenuOpen(false);
  }

  function getSubmenuPosition() {
    var pos = [0, 0];

    if (subOptions) {
      var parentMenu = (0, _utils.getParentMenu)(rootRef === null || rootRef === void 0 ? void 0 : rootRef.current);

      if (parentMenu) {
        var _parentMenu$getBoundi = parentMenu.getBoundingClientRect(),
            x = _parentMenu$getBoundi.x,
            width = _parentMenu$getBoundi.width;

        var _rootRef$current$getB = rootRef.current.getBoundingClientRect(),
            y = _rootRef$current$getB.y;

        pos[0] = x + width;
        pos[1] = y;
      }
    }

    return pos;
  }

  (0, _react.useEffect)(function () {
    if (subOptions && submenuOpenedByKeyboard) {
      var firstSubnode = (0, _utils.getFirstSubNode)(rootRef === null || rootRef === void 0 ? void 0 : rootRef.current);
      (0, _utils.focusNode)(firstSubnode);
    } // eslint-disable-next-line react-hooks/exhaustive-deps

  }, [submenuOpen]);
  var classes = (0, _classnames3.default)("".concat(prefix, "--menu-option"), (_classnames2 = {}, (0, _defineProperty2.default)(_classnames2, "".concat(prefix, "--menu-option--disabled"), disabled), (0, _defineProperty2.default)(_classnames2, "".concat(prefix, "--menu-option--active"), subOptions && submenuOpen), (0, _defineProperty2.default)(_classnames2, "".concat(prefix, "--menu-option--danger"), !subOptions && kind === 'danger'), _classnames2));
  var allowedRoles = ['menuitemradio', 'menuitemcheckbox'];
  var role = rest.role && allowedRoles.includes(rest.role) ? rest.role : 'menuitem';
  var submenuPosition = getSubmenuPosition();
  return (
    /*#__PURE__*/
    // role is either menuitemradio, menuitemcheckbox, or menuitem which are all interactive
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
    _react.default.createElement("li", (0, _extends2.default)({}, rest, {
      ref: rootRef,
      className: classes,
      role: role,
      tabIndex: -1,
      "aria-disabled": !subOptions && disabled,
      "aria-haspopup": subOptions ? true : null,
      "aria-expanded": subOptions ? submenuOpen : null,
      onKeyDown: handleKeyDown,
      onMouseEnter: subOptions ? handleMouseEnter : null,
      onMouseLeave: subOptions ? handleMouseLeave : null,
      onClick: onClick
    }), subOptions ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(MenuOptionContent, {
      label: label,
      icon: renderIcon,
      info: /*#__PURE__*/_react.default.createElement(_iconsReact.CaretRight16, null),
      indented: indented
    }), /*#__PURE__*/_react.default.createElement(_Menu.default, {
      level: level + 1,
      open: submenuOpen,
      onClose: function onClose() {
        setSubmenuOpen(false);
      },
      x: submenuPosition[0],
      y: submenuPosition[1]
    }, subOptions)) : /*#__PURE__*/_react.default.createElement(MenuOptionContent, {
      label: label,
      disabled: disabled,
      icon: renderIcon,
      info: shortcut,
      indented: indented
    }))
  );
}

MenuOptionContent.propTypes = {
  /**
   * Whether this option is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Icon that is displayed in front of the option
   */
  icon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Whether the content should be indented
   */
  indented: _propTypes.default.bool,

  /**
   * Additional information such as shortcut or caret
   */
  info: _propTypes.default.node,

  /**
   * Rendered label for the MenuOptionContent
   */
  label: _propTypes.default.node.isRequired
};
MenuOption.propTypes = {
  /**
   * Specify the children of the MenuOption
   */
  children: _propTypes.default.node,

  /**
   * Specify whether this MenuOption is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Whether the content should be indented (for example because it's in a group with options that have icons).
   * Is automatically set by Menu
   */
  indented: _propTypes.default.bool,

  /**
   * Optional prop to specify the kind of the MenuOption
   */
  kind: _propTypes.default.oneOf(['default', 'danger']),

  /**
   * Rendered label for the MenuOption
   */
  label: _propTypes.default.node.isRequired,

  /**
   * Which nested level this option is located in.
   * Is automatically set by Menu
   */
  level: _propTypes.default.number,

  /**
   * The onClick handler
   */
  onClick: _propTypes.default.func,

  /**
   * Rendered icon for the MenuOption.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Rendered shortcut for the MenuOption
   */
  shortcut: _propTypes.default.node
};
var _default = MenuOption;
exports.default = _default;