"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Modal = _interopRequireDefault(require("../Modal"));

var _Button = _interopRequireDefault(require("../Button"));

var _types = require("../../prop-types/types");

var _excluded = ["children", "onKeyDown", "buttonTriggerText", "buttonTriggerClassName", "renderTriggerButtonIcon", "triggerButtonIconDescription", "triggerButtonKind", "disabled", "handleSubmit", "shouldCloseAfterSubmit", "selectorPrimaryFocus", "preventCloseOnClickOutside"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ModalWrapper = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(ModalWrapper, _React$Component);

  var _super = _createSuper(ModalWrapper);

  function ModalWrapper() {
    var _this;

    (0, _classCallCheck2.default)(this, ModalWrapper);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "triggerButton", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "modal", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      isOpen: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOpen", function () {
      _this.setState({
        isOpen: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClose", function (evt) {
      if (evt && !_this.modal.current.innerModal.current.contains(evt.target) && _this.props.preventCloseOnClickOutside) {
        return;
      } else {
        _this.setState({
          isOpen: false
        }, function () {
          return _this.triggerButton.current.focus();
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnRequestSubmit", function () {
      var _this$props = _this.props,
          handleSubmit = _this$props.handleSubmit,
          shouldCloseAfterSubmit = _this$props.shouldCloseAfterSubmit;

      if (handleSubmit()) {
        if (shouldCloseAfterSubmit) {
          _this.handleClose();
        }
      }
    });
    return _this;
  }

  (0, _createClass2.default)(ModalWrapper, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          children = _this$props2.children,
          _onKeyDown = _this$props2.onKeyDown,
          buttonTriggerText = _this$props2.buttonTriggerText,
          buttonTriggerClassName = _this$props2.buttonTriggerClassName,
          renderTriggerButtonIcon = _this$props2.renderTriggerButtonIcon,
          triggerButtonIconDescription = _this$props2.triggerButtonIconDescription,
          triggerButtonKind = _this$props2.triggerButtonKind,
          disabled = _this$props2.disabled,
          handleSubmit = _this$props2.handleSubmit,
          shouldCloseAfterSubmit = _this$props2.shouldCloseAfterSubmit,
          selectorPrimaryFocus = _this$props2.selectorPrimaryFocus,
          preventCloseOnClickOutside = _this$props2.preventCloseOnClickOutside,
          other = (0, _objectWithoutProperties2.default)(_this$props2, _excluded);

      var props = _objectSpread(_objectSpread({}, other), {}, {
        selectorPrimaryFocus: selectorPrimaryFocus,
        open: this.state.isOpen,
        onRequestClose: this.handleClose,
        onRequestSubmit: this.handleOnRequestSubmit
      });

      return /*#__PURE__*/_react.default.createElement("div", {
        role: "presentation",
        onKeyDown: function onKeyDown(evt) {
          if (evt.which === 27) {
            _this2.handleClose();

            _onKeyDown(evt);
          }
        }
      }, /*#__PURE__*/_react.default.createElement(_Button.default, {
        className: buttonTriggerClassName,
        disabled: disabled,
        kind: triggerButtonKind,
        renderIcon: renderTriggerButtonIcon,
        iconDescription: triggerButtonIconDescription,
        onClick: this.handleOpen,
        ref: this.triggerButton
      }, buttonTriggerText), /*#__PURE__*/_react.default.createElement(_Modal.default, (0, _extends2.default)({
        ref: this.modal
      }, props), children));
    }
  }]);
  return ModalWrapper;
}(_react.default.Component);

exports.default = ModalWrapper;
(0, _defineProperty2.default)(ModalWrapper, "propTypes", {
  buttonTriggerClassName: _propTypes.default.string,
  buttonTriggerText: _propTypes.default.node,
  children: _propTypes.default.node,
  disabled: _propTypes.default.bool,
  handleOpen: _propTypes.default.func,
  handleSubmit: _propTypes.default.func,
  id: _propTypes.default.string,
  modalBeforeContent: _propTypes.default.bool,
  modalHeading: _propTypes.default.string,
  modalLabel: _propTypes.default.string,
  modalText: _propTypes.default.string,
  onKeyDown: _propTypes.default.func,
  passiveModal: _propTypes.default.bool,
  preventCloseOnClickOutside: _propTypes.default.bool,
  primaryButtonText: _propTypes.default.string,
  renderTriggerButtonIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),
  secondaryButtonText: _propTypes.default.string,
  selectorPrimaryFocus: _propTypes.default.string,
  shouldCloseAfterSubmit: _propTypes.default.bool,
  status: _propTypes.default.string,
  triggerButtonIconDescription: _propTypes.default.string,
  triggerButtonKind: _propTypes.default.oneOf(_types.ButtonKinds),
  withHeader: _propTypes.default.bool
});
(0, _defineProperty2.default)(ModalWrapper, "defaultProps", {
  primaryButtonText: 'Save',
  secondaryButtonText: 'Cancel',
  triggerButtonIconDescription: 'Provide icon description if icon is used',
  triggerButtonKind: 'primary',
  disabled: false,
  preventCloseOnClickOutside: false,
  selectorPrimaryFocus: '[data-modal-primary-focus]',
  onKeyDown: function onKeyDown() {}
});