"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultItemToString = void 0;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _invariant = _interopRequireDefault(require("invariant"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var itemToString = function itemToString(item) {
  !(typeof item.label === 'string') ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, '[MultiSelect] the default `itemToString` method expected to receive ' + 'an item with a `label` field of type `string`. Instead received: `%s`', (0, _typeof2.default)(item.label)) : invariant(false) : void 0;
  return item.label || '';
};

var defaultItemToString = function defaultItemToString(item) {
  if (Array.isArray(item)) {
    return item.map(itemToString);
  }

  return itemToString(item);
};

exports.defaultItemToString = defaultItemToString;