"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Actionable = exports.Inline = exports.Toast = exports.default = void 0;

var _FeatureFlags = require("../../FeatureFlags");

var _ = require("../");

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/Notifications',
  decorators: [function (Story) {
    return /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlags, {
      flags: {
        'enable-v11-release': true
      }
    }, /*#__PURE__*/_react.default.createElement(Story, null));
  }],
  argTypes: {
    kind: {
      options: ['error', 'info', 'info-square', 'success', 'warning', 'warning-alt'],
      control: {
        type: 'select'
      }
    },
    className: {
      control: {
        type: 'text'
      }
    }
  },
  args: {
    kind: 'error',
    children: 'Notification content',
    lowContrast: false,
    closeOnEscape: false,
    hideCloseButton: false,
    iconDescription: 'closes notification',
    statusIconDescription: 'notification',
    onClose: (0, _addonActions.action)('onClose'),
    onCloseButtonClick: (0, _addonActions.action)('onCloseButtonClick')
  }
};
exports.default = _default;

var Toast = function Toast(args) {
  return /*#__PURE__*/_react.default.createElement(_.ToastNotification, args);
};

exports.Toast = Toast;
Toast.argTypes = {
  role: {
    options: ['alert', 'log', 'status'],
    control: {
      type: 'select'
    }
  }
};
Toast.args = {
  role: 'status',
  timeout: 0
};

var Inline = function Inline(args) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.InlineNotification, args), /*#__PURE__*/_react.default.createElement(_.InlineNotification, args), /*#__PURE__*/_react.default.createElement(_.InlineNotification, args));
};

exports.Inline = Inline;
Inline.argTypes = {
  role: {
    options: ['alert', 'log', 'status'],
    control: {
      type: 'select'
    }
  }
};
Inline.args = {
  role: 'status'
};

var Actionable = function Actionable(args) {
  return /*#__PURE__*/_react.default.createElement(_.ActionableNotification, args);
};

exports.Actionable = Actionable;
Actionable.args = {
  actionButtonLabel: 'Action',
  inline: false
};