"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _keyboard = require("../../internal/keyboard");

var _warning = require("../../internal/warning");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate.js"));

var FeatureFlags = _interopRequireWildcard(require("@carbon/feature-flags"));

var _excluded = ["href", "className", "itemText", "hasDivider", "isDelete", "disabled", "closeMenu", "onClick", "handleOverflowMenuItemFocus", "onKeyDown", "primaryFocus", "wrapperClassName", "requireTitle", "index", "title"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;

var OverflowMenuItem = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(OverflowMenuItem, _React$Component);

  var _super = _createSuper(OverflowMenuItem);

  function OverflowMenuItem() {
    var _this;

    (0, _classCallCheck2.default)(this, OverflowMenuItem);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "overflowMenuItem", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setTabFocus", function (evt) {
      if ((0, _keyboard.match)(evt, _keyboard.keys.ArrowDown)) {
        _this.props.handleOverflowMenuItemFocus({
          currentIndex: _this.props.index,
          direction: 1
        });
      }

      if ((0, _keyboard.match)(evt, _keyboard.keys.ArrowUp)) {
        _this.props.handleOverflowMenuItemFocus({
          currentIndex: _this.props.index,
          direction: -1
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClick", function (evt) {
      var _this$props = _this.props,
          onClick = _this$props.onClick,
          closeMenu = _this$props.closeMenu;
      onClick(evt);

      if (closeMenu) {
        closeMenu();
      }
    });
    return _this;
  }

  (0, _createClass2.default)(OverflowMenuItem, [{
    key: "render",
    value: function render() {
      var _classNames,
          _this2 = this;

      var _this$props2 = this.props,
          href = _this$props2.href,
          className = _this$props2.className,
          itemText = _this$props2.itemText,
          hasDivider = _this$props2.hasDivider,
          isDelete = _this$props2.isDelete,
          disabled = _this$props2.disabled,
          closeMenu = _this$props2.closeMenu,
          onClick = _this$props2.onClick,
          handleOverflowMenuItemFocus = _this$props2.handleOverflowMenuItemFocus,
          _onKeyDown = _this$props2.onKeyDown,
          primaryFocus = _this$props2.primaryFocus,
          wrapperClassName = _this$props2.wrapperClassName,
          requireTitle = _this$props2.requireTitle,
          index = _this$props2.index,
          title = _this$props2.title,
          other = (0, _objectWithoutProperties2.default)(_this$props2, _excluded);

      if (process.env.NODE_ENV !== "production") {
        process.env.NODE_ENV !== "production" ? (0, _warning.warning)(closeMenu, '`<OverflowMenuItem>` detected missing `closeMenu` prop. ' + '`closeMenu` is required to let `<OverflowMenu>` close the menu upon actions on `<OverflowMenuItem>`. ' + 'Please make sure `<OverflowMenuItem>` is a direct child of `<OverflowMenu>.') : void 0;
      }

      var overflowMenuBtnClasses = (0, _classnames.default)("".concat(prefix, "--overflow-menu-options__btn"), className);
      var overflowMenuItemClasses = (0, _classnames.default)("".concat(prefix, "--overflow-menu-options__option"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--overflow-menu--divider"), hasDivider), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--overflow-menu-options__option--danger"), isDelete), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--overflow-menu-options__option--disabled"), disabled), _classNames), wrapperClassName);
      var TagToUse = href ? 'a' : 'button';

      var OverflowMenuItemContent = function () {
        if (typeof itemText !== 'string') {
          return itemText;
        }

        return /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--overflow-menu-options__option-content")
        }, itemText);
      }();

      return /*#__PURE__*/_react.default.createElement("li", {
        className: overflowMenuItemClasses,
        role: "none"
      }, /*#__PURE__*/_react.default.createElement(TagToUse, (0, _extends2.default)({}, other, {
        'data-floating-menu-primary-focus': primaryFocus || null,
        role: "menuitem",
        href: href,
        className: overflowMenuBtnClasses,
        disabled: disabled,
        onClick: this.handleClick,
        onKeyDown: function onKeyDown(evt) {
          _this2.setTabFocus(evt);

          _onKeyDown(evt);
        },
        ref: this.overflowMenuItem,
        title: requireTitle ? title || itemText : null,
        tabIndex: "-1",
        index: index
      }), OverflowMenuItemContent));
    }
  }]);
  return OverflowMenuItem;
}(_react.default.Component);

exports.default = OverflowMenuItem;
(0, _defineProperty2.default)(OverflowMenuItem, "propTypes", {
  /**
   * The CSS class name to be placed on the button element
   */
  className: _propTypes.default.string,

  /**
   * A callback to tell the parent menu component that the menu should be closed.
   */
  closeMenu: _propTypes.default.func,

  /**
   * `true` to make this menu item disabled.
   */
  disabled: _propTypes.default.bool,
  handleOverflowMenuItemFocus: _propTypes.default.func,

  /**
   * `true` to make this menu item a divider.
   */
  hasDivider: _propTypes.default.bool,

  /**
   * If given, overflow item will render as a link with the given href
   */
  href: _propTypes.default.string,
  index: _propTypes.default.number,

  /**
   * `true` to make this menu item a "danger button".
   */
  isDelete: _propTypes.default.bool,

  /**
   * The text in the menu item.
   */
  itemText: _propTypes.default.node.isRequired,

  /**
   * event handlers
   */
  onBlur: _propTypes.default.func,
  onClick: _propTypes.default.func,
  onFocus: _propTypes.default.func,
  onKeyDown: _propTypes.default.func,
  onKeyUp: _propTypes.default.func,
  onMouseDown: _propTypes.default.func,
  onMouseEnter: _propTypes.default.func,
  onMouseLeave: _propTypes.default.func,
  onMouseUp: _propTypes.default.func,

  /**
   * `true` if this menu item should get focus when the menu gets open.
   */
  primaryFocus: (0, _deprecate.default)(_propTypes.default.bool, 'The `primaryFocus` prop has been deprecated as it is no longer used. ' + 'Feel free to remove this prop from <OverflowMenuItem>. This prop will ' + 'be removed in the next major release of `carbon-components-react`. ' + 'Opt for `selectorPrimaryFocus` in `<OverflowMenu>` instead'),

  /**
   * `true` if this menu item has long text and requires a browser tooltip
   */
  requireTitle: _propTypes.default.bool,

  /**
   * Specify a title for the OverflowMenuItem
   */
  title: _propTypes.default.string,

  /**
   * The CSS class name to be placed on the wrapper list item element
   */
  wrapperClassName: _propTypes.default.string
});
(0, _defineProperty2.default)(OverflowMenuItem, "defaultProps", {
  hasDivider: false,
  isDelete: false,
  disabled: false,
  itemText: FeatureFlags.enabled('enable-v11-release') ? null : 'Provide itemText',
  onClick: function onClick() {},
  onKeyDown: function onKeyDown() {}
});