"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _keyboard = require("../../../internal/keyboard");

var _warning = require("../../../internal/warning");

var _usePrefix = require("../../../internal/usePrefix");

var _excluded = ["className", "closeMenu", "disabled", "handleOverflowMenuItemFocus", "hasDivider", "href", "isDelete", "index", "itemText", "onClick", "onKeyDown", "requireTitle", "title", "wrapperClassName"];

var OverflowMenuItem = /*#__PURE__*/_react.default.forwardRef(function OverflowMenuItem(_ref, ref) {
  var _cx;

  var className = _ref.className,
      closeMenu = _ref.closeMenu,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      handleOverflowMenuItemFocus = _ref.handleOverflowMenuItemFocus,
      _ref$hasDivider = _ref.hasDivider,
      hasDivider = _ref$hasDivider === void 0 ? false : _ref$hasDivider,
      href = _ref.href,
      _ref$isDelete = _ref.isDelete,
      isDelete = _ref$isDelete === void 0 ? false : _ref$isDelete,
      index = _ref.index,
      _ref$itemText = _ref.itemText,
      itemText = _ref$itemText === void 0 ? 'Provide itemText' : _ref$itemText,
      _ref$onClick = _ref.onClick,
      onClick = _ref$onClick === void 0 ? function () {} : _ref$onClick,
      _ref$onKeyDown = _ref.onKeyDown,
      _onKeyDown = _ref$onKeyDown === void 0 ? function () {} : _ref$onKeyDown,
      requireTitle = _ref.requireTitle,
      title = _ref.title,
      wrapperClassName = _ref.wrapperClassName,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();

  function setTabFocus(evt) {
    if ((0, _keyboard.match)(evt, _keyboard.keys.ArrowDown)) {
      handleOverflowMenuItemFocus({
        currentIndex: index,
        direction: 1
      });
    }

    if ((0, _keyboard.match)(evt, _keyboard.keys.ArrowUp)) {
      handleOverflowMenuItemFocus({
        currentIndex: index,
        direction: -1
      });
    }
  }

  function handleClick(evt) {
    onClick(evt);

    if (closeMenu) {
      closeMenu();
    }
  }

  if (process.env.NODE_ENV !== "production") {
    process.env.NODE_ENV !== "production" ? (0, _warning.warning)(closeMenu, '`<OverflowMenuItem>` detected missing `closeMenu` prop. ' + '`closeMenu` is required to let `<OverflowMenu>` close the menu upon actions on `<OverflowMenuItem>`. ' + 'Please make sure `<OverflowMenuItem>` is a direct child of `<OverflowMenu>.') : void 0;
  }

  var overflowMenuBtnClasses = (0, _classnames.default)("".concat(prefix, "--overflow-menu-options__btn"), className);
  var overflowMenuItemClasses = (0, _classnames.default)("".concat(prefix, "--overflow-menu-options__option"), (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--overflow-menu--divider"), hasDivider), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--overflow-menu-options__option--danger"), isDelete), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--overflow-menu-options__option--disabled"), disabled), _cx), wrapperClassName);
  var TagToUse = href ? 'a' : 'button';

  var OverflowMenuItemContent = function () {
    if (typeof itemText !== 'string') {
      return itemText;
    }

    return /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--overflow-menu-options__option-content")
    }, itemText);
  }();

  return /*#__PURE__*/_react.default.createElement("li", {
    className: overflowMenuItemClasses,
    role: "none"
  }, /*#__PURE__*/_react.default.createElement(TagToUse, (0, _extends2.default)({
    className: overflowMenuBtnClasses,
    disabled: disabled,
    href: href,
    index: index,
    onClick: handleClick,
    onKeyDown: function onKeyDown(evt) {
      setTabFocus(evt);

      _onKeyDown(evt);
    },
    role: "menuitem",
    ref: ref,
    tabIndex: "-1",
    title: requireTitle ? title || itemText : null
  }, rest), OverflowMenuItemContent));
});

OverflowMenuItem.propTypes = {
  /**
   * The CSS class name to be placed on the button element
   */
  className: _propTypes.default.string,

  /**
   * A callback to tell the parent menu component that the menu should be closed.
   */
  closeMenu: _propTypes.default.func,

  /**
   * `true` to make this menu item disabled.
   */
  disabled: _propTypes.default.bool,
  handleOverflowMenuItemFocus: _propTypes.default.func,

  /**
   * `true` to make this menu item a divider.
   */
  hasDivider: _propTypes.default.bool,

  /**
   * If given, overflow item will render as a link with the given href
   */
  href: _propTypes.default.string,
  index: _propTypes.default.number,

  /**
   * `true` to make this menu item a "danger button".
   */
  isDelete: _propTypes.default.bool,

  /**
   * The text in the menu item.
   */
  itemText: _propTypes.default.node.isRequired,

  /**
   * event handlers
   */
  onBlur: _propTypes.default.func,
  onClick: _propTypes.default.func,
  onFocus: _propTypes.default.func,
  onKeyDown: _propTypes.default.func,
  onKeyUp: _propTypes.default.func,
  onMouseDown: _propTypes.default.func,
  onMouseEnter: _propTypes.default.func,
  onMouseLeave: _propTypes.default.func,
  onMouseUp: _propTypes.default.func,

  /**
   * `true` if this menu item has long text and requires a browser tooltip
   */
  requireTitle: _propTypes.default.bool,

  /**
   * Specify a title for the OverflowMenuItem
   */
  title: _propTypes.default.string,

  /**
   * The CSS class name to be placed on the wrapper list item element
   */
  wrapperClassName: _propTypes.default.string
};
var _default = OverflowMenuItem;
exports.default = _default;