"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _SkeletonText = _interopRequireDefault(require("../SkeletonText"));

var _excluded = ["className"];
var prefix = _carbonComponents.settings.prefix;

function PaginationSkeleton(_ref) {
  var className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: (0, _classnames.default)("".concat(prefix, "--pagination"), "".concat(prefix, "--skeleton"), className)
  }, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--pagination__left")
  }, /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "70px"
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "35px"
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "105px"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--pagination__right ").concat(prefix, "--pagination--inline")
  }, /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "70px"
  })));
}

PaginationSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string
};
var _default = PaginationSkeleton;
exports.default = _default;