"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithNoSizerChildInputOrChildSelector = exports.WithAPageSelector = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _ = require("../../../");

/**
 * Copyright IBM Corp. 2016, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var props = function props() {
  return {
    disabled: (0, _addonKnobs.boolean)('Disable backward/forward buttons (disabled)', false),
    pagesUnknown: (0, _addonKnobs.boolean)('Total number of items unknown (pagesUnknown)', false),
    backwardText: (0, _addonKnobs.text)('The description for the backward icon (backwardText)', 'Previous page'),
    forwardText: (0, _addonKnobs.text)('The description for the forward icon (forwardText)', 'Next page'),
    pageSize: (0, _addonKnobs.number)('Number of items per page (pageSize)', 10),
    itemsPerPageText: (0, _addonKnobs.text)('Label for `pageSizes` select UI (itemsPerPageText)', 'Items per page:'),
    onChange: (0, _addonActions.action)('onChange')
  };
};

var _default = {
  title: 'Experimental/unstable_Pagination',
  decorators: [_addonKnobs.withKnobs, function (story) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '800px'
      }
    }, story());
  }]
};
exports.default = _default;

var WithAPageSelector = function WithAPageSelector() {
  return /*#__PURE__*/_react.default.createElement(_.unstable_Pagination, (0, _extends2.default)({}, props(), {
    totalItems: 350,
    pageSizes: (0, _addonKnobs.array)('Choices of `pageSize` (pageSizes)', [10, 20, 30])
  }), function (_ref) {
    var currentPage = _ref.currentPage,
        onSetPage = _ref.onSetPage,
        totalPages = _ref.totalPages;
    return /*#__PURE__*/_react.default.createElement(_.unstable_PageSelector, {
      currentPage: currentPage,
      id: "select-1",
      onChange: function onChange(event) {
        return onSetPage(event.target.value);
      },
      totalPages: totalPages
    });
  });
};

exports.WithAPageSelector = WithAPageSelector;
WithAPageSelector.storyName = 'with a page selector';
WithAPageSelector.parameters = {
  info: {
    propTables: [_.unstable_Pagination, _.unstable_PageSelector],
    text: "\n        \uD83D\uDEA8 This component is *experimental* and may change. \uD83D\uDEA8\n        `Pagination` accepts a render prop `children`.\n        This example wraps the `children` (`PageSelector`) in a function, allowing it to pass information back to the parent component.\n        ```jsx\n        {/**\n          * Provide `totalItems` to `Pagination` when using the `PageSelector` child.\n          * `Pagination` uses `totalItems` to calculate `totalPages`.\n          * And then, `PageSelector` uses the calculated `totalPages` to accurately display page options.\n          */}\n        <Pagination\n          totalItems={350}\n          pageSizes={[10, 15, 20, 25]}\n        >\n          {/**\n            * Below, `children` is a render prop, wrapped in a function.\n            * - `currentPage` is used to display the current page.\n            * - `onSetPage` is used to update the current page state in the parent component.\n            * - `totalPages` is calculated using the `totalItems` value provided to the parent component, and then is displayed below.\n            */}\n          {({ currentPage, onSetPage, totalPages }) => (\n            <PageSelector\n              currentPage={currentPage}\n              id=\"select-1\"\n              onChange={event => onSetPage(event.target.value)}\n              totalPages={totalPages}\n            />\n          )}\n        </Pagination>\n        ```\n      "
  }
};

var WithNoSizerChildInputOrChildSelector = function WithNoSizerChildInputOrChildSelector() {
  return /*#__PURE__*/_react.default.createElement(_.unstable_Pagination, (0, _extends2.default)({}, props(), {
    totalItems: 350
  }));
};

exports.WithNoSizerChildInputOrChildSelector = WithNoSizerChildInputOrChildSelector;
WithNoSizerChildInputOrChildSelector.storyName = 'with no sizer, child input, or child selector';
WithNoSizerChildInputOrChildSelector.parameters = {
  info: {
    text: "\n      \uD83D\uDEA8 This component is *experimental* and may change. \uD83D\uDEA8\n      Without `children`, `Pagination` renders without a page selector.\n    "
  }
};