"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.default = void 0;

require("./story.scss");

var _iconsReact = require("@carbon/icons-react");

var _react = _interopRequireDefault(require("react"));

var _Popover = require("../../Popover");

var _Popover2 = _interopRequireDefault(require("./Popover.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Experimental/unstable_Popover',
  component: _Popover.Popover,
  subcomponents: {
    PopoverContent: _Popover.PopoverContent
  },
  argTypes: {
    as: {
      table: {
        disable: true
      }
    },
    children: {
      table: {
        disable: true
      }
    },
    className: {
      table: {
        disable: true
      }
    },
    relative: {
      table: {
        disable: true
      }
    }
  },
  parameters: {
    controls: {
      hideNoControlsWarning: true
    },
    docs: {
      page: _Popover2.default
    }
  }
};
exports.default = _default;

var PlaygroundStory = function PlaygroundStory(props) {
  var align = props.align,
      caret = props.caret,
      dropShadow = props.dropShadow,
      highContrast = props.highContrast,
      light = props.light,
      open = props.open;
  return /*#__PURE__*/_react.default.createElement(_Popover.Popover, {
    align: align,
    caret: caret,
    dropShadow: dropShadow,
    highContrast: highContrast,
    light: light,
    open: open
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "playground-trigger"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Checkbox16, null)), /*#__PURE__*/_react.default.createElement(_Popover.PopoverContent, {
    className: "p-3"
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "popover-title"
  }, "Available storage"), /*#__PURE__*/_react.default.createElement("p", {
    className: "popover-details"
  }, "This server has 150 GB of block storage remaining.")));
};

var Playground = PlaygroundStory.bind({});
exports.Playground = Playground;
Playground.argTypes = {
  align: {
    options: ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top'],
    control: {
      type: 'select'
    }
  },
  caret: {
    control: {
      type: 'boolean'
    },
    defaultValue: true
  },
  dropShadow: {
    control: {
      type: 'boolean'
    },
    defaultValue: true
  },
  highContrast: {
    control: {
      type: 'boolean'
    },
    defaultValue: false
  },
  light: {
    control: {
      type: 'boolean'
    },
    defaultValue: false
  },
  open: {
    control: {
      type: 'boolean'
    },
    defaultValue: true
  }
};
Playground.story = {
  decorators: [function (story) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mt-10 flex justify-center"
    }, story());
  }]
};