"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Portal = Portal;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = require("react");

var _reactDom = _interopRequireDefault(require("react-dom"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * Helper component for rendering content within a portal. By default, the
 * portal will render into document.body. You can customize this behavior with
 * the `container` prop. Any `children` provided to this component will be
 * rendered inside of the container.
 */
function Portal(_ref) {
  var container = _ref.container,
      children = _ref.children;

  var _useState = (0, _react.useState)(null),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      mountNode = _useState2[0],
      setMountNode = _useState2[1];

  (0, _react.useEffect)(function () {
    setMountNode(container ? container.current : document.body);
  }, [container]);

  if (mountNode) {
    return /*#__PURE__*/_reactDom.default.createPortal(children, mountNode);
  }

  return null;
}

Portal.propTypes = {
  /**
   * Specify the children elements to be rendered inside of the <Portal>
   */
  children: _propTypes.default.node,

  /**
   * Provide a ref for a container node to render the portal
   */
  container: _propTypes.default.oneOfType([_propTypes.default.shape({
    current: _propTypes.default.any
  })])
};