"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressStep = ProgressStep;
exports.ProgressIndicator = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames4 = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _keyboard = require("../../internal/keyboard");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["label", "description", "className", "current", "complete", "invalid", "secondaryLabel", "disabled", "onClick", "renderLabel", "translateWithId"],
    _excluded2 = ["className", "currentIndex", "vertical", "spaceEqually"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultRenderLabel = function defaultRenderLabel(props) {
  return /*#__PURE__*/_react.default.createElement("p", props);
};

var defaultTranslations = {
  'carbon.progress-step.complete': 'Complete',
  'carbon.progress-step.incomplete': 'Incomplete',
  'carbon.progress-step.current': 'Current',
  'carbon.progress-step.invalid': 'Invalid'
};

function translateWithId(messageId) {
  return defaultTranslations[messageId];
}

function ProgressStep(_ref) {
  var _classnames;

  var label = _ref.label,
      description = _ref.description,
      className = _ref.className,
      current = _ref.current,
      complete = _ref.complete,
      invalid = _ref.invalid,
      secondaryLabel = _ref.secondaryLabel,
      disabled = _ref.disabled,
      onClick = _ref.onClick,
      ProgressStepLabel = _ref.renderLabel,
      t = _ref.translateWithId,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames4.default)((_classnames = {}, (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--progress-step"), true), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--progress-step--current"), current), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--progress-step--complete"), complete), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--progress-step--incomplete"), !complete && !current), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--progress-step--disabled"), disabled), (0, _defineProperty2.default)(_classnames, className, className), _classnames));

  var handleKeyDown = function handleKeyDown(e) {
    if ((0, _keyboard.matches)(e, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
      onClick();
    }
  }; // eslint-disable-next-line react/prop-types


  var SVGIcon = function SVGIcon(_ref2) {
    var complete = _ref2.complete,
        current = _ref2.current,
        description = _ref2.description,
        invalid = _ref2.invalid,
        prefix = _ref2.prefix;

    if (invalid) {
      return /*#__PURE__*/_react.default.createElement(_iconsReact.Warning16, {
        className: "".concat(prefix, "--progress__warning")
      }, /*#__PURE__*/_react.default.createElement("title", null, description));
    }

    if (current) {
      return /*#__PURE__*/_react.default.createElement(_iconsReact.CircleFilled16, null, /*#__PURE__*/_react.default.createElement("title", null, description));
    }

    if (complete) {
      return /*#__PURE__*/_react.default.createElement(_iconsReact.CheckmarkOutline16, null, /*#__PURE__*/_react.default.createElement("title", null, description));
    }

    return /*#__PURE__*/_react.default.createElement(_iconsReact.RadioButton16, null, /*#__PURE__*/_react.default.createElement("title", null, description));
  };

  var message = t('carbon.progress-step.incomplete');

  if (current) {
    message = t('carbon.progress-step.current');
  }

  if (complete) {
    message = t('carbon.progress-step.complete');
  }

  if (invalid) {
    message = t('carbon.progress-step.invalid');
  }

  return /*#__PURE__*/_react.default.createElement("li", {
    className: classes
  }, /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    type: "button",
    className: (0, _classnames4.default)("".concat(prefix, "--progress-step-button"), (0, _defineProperty2.default)({}, "".concat(prefix, "--progress-step-button--unclickable"), !onClick || current)),
    disabled: disabled,
    "aria-disabled": disabled,
    tabIndex: !current && onClick && !disabled ? 0 : -1,
    onClick: !current ? onClick : undefined,
    onKeyDown: handleKeyDown,
    title: label
  }, rest), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--assistive-text")
  }, message), /*#__PURE__*/_react.default.createElement(SVGIcon, {
    complete: complete,
    current: current,
    description: description,
    invalid: invalid,
    prefix: prefix
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--progress-text")
  }, /*#__PURE__*/_react.default.createElement(ProgressStepLabel, {
    className: "".concat(prefix, "--progress-label")
  }, label), secondaryLabel !== null && secondaryLabel !== undefined ? /*#__PURE__*/_react.default.createElement("p", {
    className: "".concat(prefix, "--progress-optional")
  }, secondaryLabel) : null), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--progress-line")
  })));
}

ProgressStep.propTypes = {
  /**
   * Provide an optional className to be applied to the containing `<li>` node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the step has been completed
   */
  complete: _propTypes.default.bool,

  /**
   * Specify whether the step is the current step
   */
  current: _propTypes.default.bool,

  /**
   * Provide a description for the <ProgressStep>
   */
  description: _propTypes.default.string,

  /**
   * Specify whether the step is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Index of the current step within the ProgressIndicator
   */
  index: _propTypes.default.number,

  /**
   * Specify whether the step is invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Provide the label for the <ProgressStep>
   */
  label: _propTypes.default.node.isRequired,

  /**
   * A callback called if the step is clicked or the enter key is pressed
   */
  onClick: _propTypes.default.func,

  /**
   * Provide the props that describe a progress step tooltip
   */
  overflowTooltipProps: _propTypes.default.object,

  /*
   * An optional parameter to allow for overflow content to be rendered in a
   * tooltip.
   */
  renderLabel: _propTypes.default.func,

  /**
   * Provide an optional secondary label
   */
  secondaryLabel: _propTypes.default.string,

  /**
   * The ID of the tooltip content.
   */
  tooltipId: _propTypes.default.string,

  /**
   * Optional method that takes in a message id and returns an
   * internationalized string.
   */
  translateWithId: _propTypes.default.func
};
ProgressStep.defaultProps = {
  renderLabel: defaultRenderLabel,
  translateWithId: translateWithId
};

var ProgressIndicator = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ProgressIndicator, _Component);

  var _super = _createSuper(ProgressIndicator);

  function ProgressIndicator() {
    var _this;

    (0, _classCallCheck2.default)(this, ProgressIndicator);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {});
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderSteps", function () {
      var onChange = _this.props.onChange;
      return _react.default.Children.map(_this.props.children, function (child, index) {
        // only setup click handlers if onChange event is passed
        var onClick = onChange ? function () {
          return onChange(index);
        } : undefined;

        if (index === _this.state.currentIndex) {
          return /*#__PURE__*/_react.default.cloneElement(child, {
            current: true,
            index: index,
            onClick: onClick
          });
        }

        if (index < _this.state.currentIndex) {
          return /*#__PURE__*/_react.default.cloneElement(child, {
            complete: true,
            index: index,
            onClick: onClick
          });
        }

        if (index > _this.state.currentIndex) {
          return /*#__PURE__*/_react.default.cloneElement(child, {
            complete: child.props.complete || false,
            index: index,
            onClick: onClick
          });
        }

        return null;
      });
    });
    return _this;
  }

  (0, _createClass2.default)(ProgressIndicator, [{
    key: "render",
    value: function render() {
      var _classnames3;

      var _this$props = this.props,
          className = _this$props.className,
          currentIndex = _this$props.currentIndex,
          vertical = _this$props.vertical,
          spaceEqually = _this$props.spaceEqually,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded2);
      var prefix = this.context;
      var classes = (0, _classnames4.default)((_classnames3 = {}, (0, _defineProperty2.default)(_classnames3, "".concat(prefix, "--progress"), true), (0, _defineProperty2.default)(_classnames3, "".concat(prefix, "--progress--vertical"), vertical), (0, _defineProperty2.default)(_classnames3, "".concat(prefix, "--progress--space-equal"), spaceEqually && !vertical), (0, _defineProperty2.default)(_classnames3, className, className), _classnames3));
      return /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
        className: classes
      }, other), this.renderSteps());
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref3, state) {
      var currentIndex = _ref3.currentIndex;
      var prevCurrentIndex = state.prevCurrentIndex;
      return prevCurrentIndex === currentIndex ? null : {
        currentIndex: currentIndex,
        prevCurrentIndex: currentIndex
      };
    }
  }]);
  return ProgressIndicator;
}(_react.Component);

exports.ProgressIndicator = ProgressIndicator;
(0, _defineProperty2.default)(ProgressIndicator, "propTypes", {
  /**
   * Provide <ProgressStep> components to be rendered in the
   * <ProgressIndicator>
   */
  children: _propTypes.default.node,

  /**
   * Provide an optional className to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Optionally specify the current step array index
   */
  currentIndex: _propTypes.default.number,

  /**
   * Optional callback called if a ProgressStep is clicked on.  Returns the index of the step.
   */
  onChange: _propTypes.default.func,

  /**
   * Specify whether the progress steps should be split equally in size in the div
   */
  spaceEqually: _propTypes.default.bool,

  /**
   * Determines whether or not the ProgressIndicator should be rendered vertically.
   */
  vertical: _propTypes.default.bool
});
(0, _defineProperty2.default)(ProgressIndicator, "contextType", _usePrefix.PrefixContext);
(0, _defineProperty2.default)(ProgressIndicator, "defaultProps", {
  currentIndex: 0
});